/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.webapp.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.tobarsegais.webapp.data.TocEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class Topic
extends TocEntry {
    private static final long serialVersionUID = 1L;

    public Topic(String label, String href, Topic ... children) {
        this(label, href, Arrays.asList(children));
    }

    public Topic(String label, String href, Collection<Topic> children) {
        super(label, href, children);
    }

    public static Topic read(XMLStreamReader reader) throws XMLStreamException {
        if (reader.getEventType() != 1) {
            throw new IllegalStateException("Expecting a start element");
        }
        if (!"topic".equals(reader.getLocalName())) {
            throw new IllegalStateException("Expecting a <topic> element, got a <" + reader.getLocalName() + ">");
        }
        String label = reader.getAttributeValue(null, "label");
        String href = reader.getAttributeValue(null, "href");
        ArrayList<Topic> topics = new ArrayList<Topic>();
        int depth = 0;
        while (reader.hasNext() && depth >= 0) {
            switch (reader.next()) {
                case 1: {
                    if (depth == 0 && "topic".equals(reader.getLocalName())) {
                        topics.add(Topic.read((XMLStreamReader)reader));
                        break;
                    }
                    ++depth;
                    break;
                }
                case 2: {
                    --depth;
                }
            }
        }
        return new Topic(label, href, topics);
    }

    public void write(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("topic");
        writer.writeAttribute("label", this.getLabel());
        writer.writeAttribute("href", this.getHref());
        for (Topic topic : this.getChildren()) {
            topic.write(writer);
        }
        writer.writeEndElement();
    }
}

