/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.doxia.Doxia;
import org.apache.maven.doxia.docrenderer.AbstractDocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.document.DocumentAuthor;
import org.apache.maven.doxia.document.DocumentCover;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.module.site.SiteModule;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.parser.manager.ParserNotFoundException;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.tobarsegais.maven.CapturingSink;
import org.tobarsegais.maven.model.BundleFile;
import org.tobarsegais.maven.model.BundleModel;
import org.tobarsegais.maven.model.io.xpp3.BundleXpp3Reader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenerateMojo
extends AbstractMojo {
    @Parameter(defaultValue="${basedir/src/docs/bundle.xml}")
    protected File bundle;
    @Parameter(defaultValue="${basedir}/src/docs")
    protected File sourceDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File outputDirectory;
    @Parameter(property="tobairsegais.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String sourceEncoding;
    @Parameter(defaultValue="${project.build.outputEncoding}")
    protected String outputEncoding;
    @Component
    protected MavenProject project;
    @Component
    protected MavenProjectHelper projectHelper;
    @Component
    protected Doxia doxia;

    public DocumentCover getDocumentCover(BundleModel bundleModel, Date date) {
        DocumentCover cover = new DocumentCover();
        cover.setAuthors(this.getAuthors());
        cover.setCompanyName(StringUtils.defaultString((Object)bundleModel.getCompanyName(), this.project.getOrganization() != null && StringUtils.isNotBlank((String)this.project.getOrganization().getName()) ? this.project.getOrganization().getName() : null));
        cover.setCompanyLogo(bundleModel.getCompanyLogo());
        cover.setProjectName(bundleModel.getProjectName());
        cover.setProjectLogo(bundleModel.getProjectLogo());
        cover.setCoverDate(date);
        cover.setCoverVersion(StringUtils.defaultString((Object)bundleModel.getVersion(), (String)this.project.getVersion()));
        cover.setCoverSubTitle(bundleModel.getSubject());
        cover.setCoverTitle(StringUtils.defaultString((Object)bundleModel.getTitle(), (String)this.getProjectName()));
        return cover;
    }

    public DocumentMeta getDocumentMeta(BundleModel bundleModel, Date date) {
        DocumentMeta meta = new DocumentMeta();
        meta.setAuthors(this.getAuthors());
        meta.setCreationDate(date);
        meta.setCreator(System.getProperty("user.name"));
        meta.setDate(date);
        meta.setDescription(StringUtils.defaultString((Object)bundleModel.getDescription(), (String)this.project.getDescription()));
        meta.setInitialCreator(System.getProperty("user.name"));
        meta.setSubject(bundleModel.getSubject());
        meta.setTitle(StringUtils.defaultString((Object)bundleModel.getTitle(), (String)this.getProjectName()));
        return meta;
    }

    public String getProjectName() {
        return StringUtils.isEmpty((String)this.project.getName()) ? this.project.getGroupId() + ":" + this.project.getArtifactId() : this.project.getName();
    }

    List<DocumentAuthor> getAuthors() {
        if (this.project.getDevelopers() == null) {
            return null;
        }
        ArrayList<DocumentAuthor> authors = new ArrayList<DocumentAuthor>(this.project.getDevelopers().size());
        for (Developer d : this.project.getDevelopers()) {
            DocumentAuthor author = new DocumentAuthor();
            author.setName(d.getName());
            author.setCompanyName(d.getOrganization());
            authors.add(author);
        }
        return authors;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Generation skipped");
            return;
        }
        if (!this.bundle.isFile()) {
            this.getLog().warn((CharSequence)("Missing bundle descriptor '" + this.bundle + "'. Nothing to do."));
            return;
        }
        if (this.sourceDirectory.isFile()) {
            throw new MojoExecutionException("Source directory '" + this.sourceDirectory + "' is not a directory");
        }
        if (!this.sourceDirectory.isDirectory()) {
            this.getLog().info((CharSequence)("Source directory '" + this.sourceDirectory + " does not exist. Nothing to do."));
            return;
        }
        if (this.outputDirectory.isFile()) {
            throw new MojoExecutionException("Output directory '" + this.outputDirectory + "' is not a directory");
        }
        if (!this.outputDirectory.isDirectory() && !this.outputDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create output directory '" + this.outputDirectory + "'.");
        }
        if (!this.getOutputFile().getParentFile().isDirectory() && !this.getOutputFile().getParentFile().mkdirs()) {
            throw new MojoExecutionException("Could not create output directory '" + this.getOutputFile().getParentFile() + "'.");
        }
        BundleXpp3Reader reader = new BundleXpp3Reader();
        FileInputStream fis = null;
        fis = new FileInputStream(this.bundle);
        BundleModel bundleModel = reader.read(fis, false);
        IOUtil.close((InputStream)fis);
        Date date = new Date();
        try {
            DocumentModel model = new DocumentModel();
            model.setModelEncoding(StringUtils.defaultString((Object)this.outputEncoding, (String)"UTF-8"));
            model.setOutputName(this.getOutputFile().getName());
            model.setMeta(this.getDocumentMeta(bundleModel, date));
            model.setCover(this.getDocumentCover(bundleModel, date));
            model.setToc(new DocumentTOC());
            model.getToc().setDepth(3);
            model.getToc().setName("Contents");
            Map toProcess = this.getRenderer().getFilesToProcess(this.sourceDirectory);
            Iterator<BundleFile> iterator = bundleModel.getFiles().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.render(model);
                    return;
                }
                BundleFile f = iterator.next();
                DocumentTOCItem item = this.toDocumentTOCItem(f, toProcess);
                model.getToc().addItem(item);
            }
        }
        catch (DocumentRendererException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (XmlPullParserException e) {
            try {
                throw new MojoExecutionException("Could not read bundle '" + this.bundle + "'", (Exception)((Object)e));
                catch (IOException e2) {
                    throw new MojoExecutionException("Could not read bundle '" + this.bundle + "'", (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(fis);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DocumentTOCItem toDocumentTOCItem(BundleFile f, Map<String, SiteModule> contentFiles) throws FileNotFoundException, UnsupportedEncodingException {
        DocumentTOCItem item;
        block14: {
            block13: {
                item = new DocumentTOCItem();
                if (!StringUtils.isBlank((String)f.getTitle())) break block13;
                boolean found = false;
                for (Map.Entry<String, SiteModule> entry : contentFiles.entrySet()) {
                    if (!f.getSrc().equals(entry.getKey()) && !f.getSrc().equals(FilenameUtils.removeExtension((String)entry.getKey()))) continue;
                    try {
                        CapturingSink sink;
                        block12: {
                            FileInputStream fis;
                            block11: {
                                Parser parser = this.doxia.getParser(entry.getValue().getParserId());
                                fis = null;
                                sink = null;
                                try {
                                    fis = new FileInputStream(new File(new File(this.sourceDirectory, entry.getValue().getSourceDirectory()), entry.getKey()));
                                    sink = new CapturingSink();
                                    parser.parse((Reader)new InputStreamReader((InputStream)fis, this.sourceEncoding), (Sink)sink);
                                    if (sink == null) break block11;
                                }
                                catch (ParseException e) {
                                    this.getLog().error((Throwable)e);
                                    break block12;
                                }
                                finally {
                                    if (sink != null) {
                                        sink.close();
                                    }
                                    IOUtil.close(fis);
                                }
                                sink.close();
                            }
                            IOUtil.close((InputStream)fis);
                        }
                        item.setName(sink.getTitle());
                        found = true;
                    }
                    catch (ParserNotFoundException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                if (!found) {
                    item.setName(new File(this.sourceDirectory, f.getSrc()).getName());
                }
                break block14;
            }
            item.setName(f.getTitle());
        }
        item.setRef(f.getSrc() + ".html");
        for (BundleFile file : f.getFiles()) {
            item.addItem(this.toDocumentTOCItem(file, contentFiles));
        }
        return item;
    }

    protected abstract AbstractDocumentRenderer getRenderer();

    protected abstract File getOutputFile();

    protected abstract void render(DocumentModel var1) throws DocumentRendererException, IOException;
}

