/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.maven;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.module.xhtml.AbstractXhtmlSink;
import org.apache.maven.doxia.module.xhtml.XhtmlSinkFactory;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarXhtmlSink
extends AbstractXhtmlSink {
    private final JarOutputStream outputStream;
    private final XhtmlSinkFactory factory;
    private Sink delegate;
    private String encoding;
    private StringBuilder sectionTitleBuffer;
    private boolean sectionHasID;
    private boolean isSectionTitle;
    private Set<String> anchorsInSectionTitle;

    public JarXhtmlSink(JarOutputStream outputStream, XhtmlSinkFactory factory, String encoding) {
        this.outputStream = outputStream;
        this.factory = factory;
        this.encoding = encoding;
    }

    public JarOutputStream getOutputStream() {
        return this.outputStream;
    }

    public void file(String name) throws IOException {
        this.file(name, System.currentTimeMillis());
    }

    public void file(String name, long time) throws IOException {
        if (this.delegate != null) {
            this.file_();
        }
        JarEntry entry = new JarEntry(name + ".html");
        entry.setTime(time);
        this.outputStream.putNextEntry(entry);
        this.delegate = this.factory.createSink((OutputStream)new NoCloseOutputStream(this.outputStream), this.encoding);
    }

    public void file_() {
        if (this.delegate != null) {
            this.delegate.close();
            this.delegate = null;
        }
    }

    public void toc(DocumentTOC toc) {
        this.delegate.section1();
        this.delegate.sectionTitle1();
        this.delegate.text(toc.getName());
        this.delegate.sectionTitle1_();
        this.writeTocItems(toc.getItems(), 1);
        this.delegate.section1_();
    }

    private void writeTocItems(List<DocumentTOCItem> tocItems, int level) {
        int maxTocLevel = 4;
        if (level < 1 || level > 4 || tocItems.isEmpty()) {
            return;
        }
        this.delegate.list((SinkEventAttributes)new SinkEventAttributeSet(new String[]{"style", "list-style-type:none;"}));
        for (DocumentTOCItem tocItem : tocItems) {
            this.delegate.listItem();
            this.delegate.link(tocItem.getRef());
            this.delegate.text(tocItem.getName());
            this.delegate.link_();
            if (tocItem.getItems() != null) {
                this.writeTocItems(tocItem.getItems(), level + 1);
            }
            this.delegate.listItem_();
        }
        this.delegate.list_();
    }

    public void author_() {
        this.delegate.author_();
    }

    public void body() {
        this.delegate.body();
    }

    public void body_() {
        this.delegate.body_();
    }

    public void date_() {
        this.delegate.date_();
    }

    public void head() {
        this.delegate.head();
    }

    public void head_() {
        this.delegate.head_();
    }

    public void title() {
        this.delegate.title();
    }

    public void title_() {
        this.delegate.title_();
    }

    public void anchor(String name) {
        this.anchor(name, null);
    }

    public void anchor(String name, SinkEventAttributes attributes) {
        this.delegate.anchor(name, attributes);
        if (this.isSectionTitle) {
            if (this.anchorsInSectionTitle == null) {
                this.anchorsInSectionTitle = new HashSet<String>();
            }
            this.anchorsInSectionTitle.add(name);
        }
    }

    public void anchor_() {
        this.delegate.anchor_();
    }

    public void bold() {
        this.delegate.bold();
    }

    public void bold_() {
        this.delegate.bold_();
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
        this.file_();
    }

    public void comment(String comment) {
        this.delegate.comment(comment);
    }

    public void definedTerm() {
        this.delegate.definedTerm();
    }

    public void definedTerm(SinkEventAttributes attributes) {
        this.delegate.definedTerm(attributes);
    }

    public void definedTerm_() {
        this.delegate.definedTerm_();
    }

    public void definition() {
        this.delegate.definition();
    }

    public void definition(SinkEventAttributes attributes) {
        this.delegate.definition(attributes);
    }

    public void definition_() {
        this.delegate.definition_();
    }

    public void definitionList() {
        this.delegate.definitionList();
    }

    public void definitionList(SinkEventAttributes attributes) {
        this.delegate.definitionList(attributes);
    }

    public void definitionList_() {
        this.delegate.definitionList_();
    }

    public void figure() {
        this.delegate.figure();
    }

    public void figure(SinkEventAttributes attributes) {
        this.delegate.figure(attributes);
    }

    public void figure_() {
        this.delegate.figure_();
    }

    public void figureCaption() {
        this.delegate.figureCaption();
    }

    public void figureCaption(SinkEventAttributes attributes) {
        this.delegate.figureCaption(attributes);
    }

    public void figureCaption_() {
        this.delegate.figureCaption_();
    }

    public void figureGraphics(String name) {
        this.delegate.figureGraphics(name);
    }

    public void figureGraphics(String src, SinkEventAttributes attributes) {
        this.delegate.figureGraphics(src, attributes);
    }

    public void flush() {
        this.delegate.flush();
    }

    public void horizontalRule() {
        this.delegate.horizontalRule();
    }

    public void horizontalRule(SinkEventAttributes attributes) {
        this.delegate.horizontalRule(attributes);
    }

    public void italic() {
        this.delegate.italic();
    }

    public void italic_() {
        this.delegate.italic_();
    }

    public void lineBreak() {
        this.delegate.lineBreak();
    }

    public void lineBreak(SinkEventAttributes attributes) {
        this.delegate.lineBreak(attributes);
    }

    public void link(String name) {
        this.delegate.link(name);
    }

    public void link(String name, SinkEventAttributes attributes) {
        this.delegate.link(name, attributes);
    }

    public void link_() {
        this.delegate.link_();
    }

    public void list() {
        this.delegate.list();
    }

    public void list(SinkEventAttributes attributes) {
        this.delegate.list(attributes);
    }

    public void list_() {
        this.delegate.list_();
    }

    public void listItem() {
        this.delegate.listItem();
    }

    public void listItem(SinkEventAttributes attributes) {
        this.delegate.listItem(attributes);
    }

    public void listItem_() {
        this.delegate.listItem_();
    }

    public void monospaced() {
        this.delegate.monospaced();
    }

    public void monospaced_() {
        this.delegate.monospaced_();
    }

    public void nonBreakingSpace() {
        this.delegate.nonBreakingSpace();
    }

    public void numberedList(int numbering) {
        this.delegate.numberedList(numbering);
    }

    public void numberedList(int numbering, SinkEventAttributes attributes) {
        this.delegate.numberedList(numbering, attributes);
    }

    public void numberedList_() {
        this.delegate.numberedList_();
    }

    public void numberedListItem() {
        this.delegate.numberedListItem();
    }

    public void numberedListItem(SinkEventAttributes attributes) {
        this.delegate.numberedListItem(attributes);
    }

    public void numberedListItem_() {
        this.delegate.numberedListItem_();
    }

    public void pageBreak() {
        this.delegate.pageBreak();
    }

    public void paragraph() {
        this.delegate.paragraph();
    }

    public void paragraph(SinkEventAttributes attributes) {
        this.delegate.paragraph(attributes);
    }

    public void paragraph_() {
        this.delegate.paragraph_();
    }

    public void rawText(String text) {
        this.delegate.rawText(text);
    }

    public void section(int level, SinkEventAttributes attributes) {
        this.delegate.section(level, attributes);
        this.onSectionTitle(level, attributes);
    }

    public void section1() {
        this.delegate.section1();
        this.onSectionTitle(1, null);
    }

    public void section1_() {
        this.delegate.section1_();
        this.onSectionTitle_(1);
    }

    public void section2() {
        this.delegate.section2();
        this.onSectionTitle(2, null);
    }

    public void section2_() {
        this.delegate.section2_();
        this.onSectionTitle_(2);
    }

    public void section3() {
        this.delegate.section3();
        this.onSectionTitle(3, null);
    }

    public void section3_() {
        this.delegate.section3_();
        this.onSectionTitle_(3);
    }

    public void section4() {
        this.delegate.section4();
        this.onSectionTitle(4, null);
    }

    public void section4_() {
        this.delegate.section4_();
        this.onSectionTitle_(4);
    }

    public void section5() {
        this.delegate.section5();
        this.onSectionTitle(5, null);
    }

    public void section5_() {
        this.delegate.section5_();
        this.onSectionTitle_(5);
    }

    public void section_(int level) {
        this.delegate.section_(level);
        this.onSectionTitle_(level);
    }

    protected void onSectionTitle(int depth, SinkEventAttributes attributes) {
        this.sectionTitleBuffer = new StringBuilder();
        this.sectionHasID = attributes != null && attributes.isDefined((Object)HTML.Attribute.ID.toString());
        this.isSectionTitle = true;
    }

    protected void onSectionTitle_(int depth) {
        String sectionTitle = this.sectionTitleBuffer.toString();
        this.sectionTitleBuffer = null;
        if (!this.sectionHasID && !StringUtils.isEmpty((String)sectionTitle)) {
            String id = HtmlTools.encodeId((String)sectionTitle);
            if (this.anchorsInSectionTitle == null || !this.anchorsInSectionTitle.contains(id)) {
                this.anchor(id);
                this.anchor_();
            }
        } else {
            this.sectionHasID = false;
        }
        this.isSectionTitle = false;
        this.anchorsInSectionTitle = null;
    }

    public void sectionTitle(int level, SinkEventAttributes attributes) {
        this.delegate.sectionTitle(level, attributes);
    }

    public void sectionTitle1() {
        this.delegate.sectionTitle1();
    }

    public void sectionTitle1_() {
        this.delegate.sectionTitle1_();
    }

    public void sectionTitle2() {
        this.delegate.sectionTitle2();
    }

    public void sectionTitle2_() {
        this.delegate.sectionTitle2_();
    }

    public void sectionTitle3() {
        this.delegate.sectionTitle3();
    }

    public void sectionTitle3_() {
        this.delegate.sectionTitle3_();
    }

    public void sectionTitle4() {
        this.delegate.sectionTitle4();
    }

    public void sectionTitle4_() {
        this.delegate.sectionTitle4_();
    }

    public void sectionTitle5() {
        this.delegate.sectionTitle5();
    }

    public void sectionTitle5_() {
        this.delegate.sectionTitle5_();
    }

    public void sectionTitle_(int level) {
        this.delegate.sectionTitle_(level);
    }

    public void table() {
        this.delegate.table();
    }

    public void table(SinkEventAttributes attributes) {
        this.delegate.table(attributes);
    }

    public void table_() {
        this.delegate.table_();
    }

    public void tableCaption() {
        this.delegate.tableCaption();
    }

    public void tableCaption(SinkEventAttributes attributes) {
        this.delegate.tableCaption(attributes);
    }

    public void tableCaption_() {
        this.delegate.tableCaption_();
    }

    public void tableCell() {
        this.delegate.tableCell();
    }

    public void tableCell(SinkEventAttributes attributes) {
        this.delegate.tableCell(attributes);
    }

    public void tableCell(String width) {
        this.delegate.tableCell(width);
    }

    public void tableCell_() {
        this.delegate.tableCell_();
    }

    public void tableHeaderCell() {
        this.delegate.tableHeaderCell();
    }

    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.delegate.tableHeaderCell(attributes);
    }

    public void tableHeaderCell(String width) {
        this.delegate.tableHeaderCell(width);
    }

    public void tableHeaderCell_() {
        this.delegate.tableHeaderCell_();
    }

    public void tableRow() {
        this.delegate.tableRow();
    }

    public void tableRow(SinkEventAttributes attributes) {
        this.delegate.tableRow(attributes);
    }

    public void tableRow_() {
        this.delegate.tableRow_();
    }

    public void tableRows(int[] justification, boolean grid) {
        this.delegate.tableRows(justification, grid);
    }

    public void tableRows_() {
        this.delegate.tableRows_();
    }

    public void text(String text) {
        this.text(text, null);
    }

    public void text(String text, SinkEventAttributes attributes) {
        if (this.sectionTitleBuffer != null) {
            this.sectionTitleBuffer.append(text);
        }
        this.delegate.text(text, attributes);
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        this.delegate.unknown(name, requiredParams, attributes);
    }

    public void verbatim(SinkEventAttributes attributes) {
        this.delegate.verbatim(attributes);
    }

    public void verbatim(boolean boxed) {
        this.delegate.verbatim(boxed);
    }

    public void verbatim_() {
        this.delegate.verbatim_();
    }

    public void author() {
        this.delegate.author();
    }

    public void author(SinkEventAttributes attributes) {
        this.delegate.author(attributes);
    }

    public void body(SinkEventAttributes attributes) {
        this.delegate.body(attributes);
    }

    public void date() {
        this.delegate.date();
    }

    public void date(SinkEventAttributes attributes) {
        this.delegate.date(attributes);
    }

    public void definitionListItem() {
        this.delegate.definitionListItem();
    }

    public void definitionListItem(SinkEventAttributes attributes) {
        this.delegate.definitionListItem(attributes);
    }

    public void definitionListItem_() {
        this.delegate.definitionListItem_();
    }

    public void head(SinkEventAttributes attributes) {
        this.delegate.head(attributes);
    }

    public void sectionTitle() {
        this.delegate.sectionTitle();
    }

    public void sectionTitle_() {
        this.delegate.sectionTitle_();
    }

    public void title(SinkEventAttributes attributes) {
        this.delegate.title(attributes);
    }

    private static class NoCloseOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        private NoCloseOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        public void close() throws IOException {
            this.delegate.flush();
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        public void write(int b) throws IOException {
            this.delegate.write(b);
        }
    }
}

