/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.doxia.docrenderer.AbstractDocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRenderer;
import org.apache.maven.doxia.docrenderer.DocumentRendererContext;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOC;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.module.site.SiteModule;
import org.apache.maven.doxia.module.xhtml.XhtmlSinkFactory;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.tobarsegais.maven.JarXhtmlSink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=DocumentRenderer.class, hint="bundle")
public class BundleRenderer
extends AbstractDocumentRenderer {
    @Requirement(role=SinkFactory.class, hint="xhtml")
    private XhtmlSinkFactory sinkFactory;

    public void render(Map<String, SiteModule> filesToProcess, File outputDirectory, DocumentModel documentModel) throws DocumentRendererException, IOException {
        this.render(filesToProcess, outputDirectory, documentModel, null);
    }

    public String getOutputExtension() {
        return "jar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Map<String, SiteModule> filesToProcess, File outputDirectory, DocumentModel documentModel, DocumentRendererContext context) throws DocumentRendererException, IOException {
        String outputName = this.getOutputName(documentModel);
        File outputFile = new File(outputDirectory, outputName + "." + this.getOutputExtension());
        if (!outputFile.getParentFile().exists()) {
            outputFile.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        JarOutputStream jos = null;
        JarXhtmlSink sink = null;
        try {
            fos = new FileOutputStream(outputFile);
            jos = new JarOutputStream(fos);
            sink = new JarXhtmlSink(jos, this.sinkFactory, context == null ? ReaderFactory.FILE_ENCODING : context.getInputEncoding());
            this.copyResources(sink.getOutputStream());
            if (documentModel.getToc() == null || documentModel.getToc().getItems() == null) {
                this.getLogger().info("No TOC is defined in the document descriptor. Merging all documents.");
                this.renderPluginXml(sink, documentModel, context);
                this.renderTocXml(sink, documentModel, context);
                this.renderTocXhtml(sink, documentModel, context);
                this.mergeAllSources(filesToProcess, sink, context);
            } else {
                this.getLogger().debug("Using TOC defined in the document descriptor.");
                this.renderPluginXml(sink, documentModel, context);
                this.renderTocXml(sink, documentModel, context);
                this.renderTocXhtml(sink, documentModel, context);
                this.mergeSourcesFromTOC(documentModel.getToc(), sink, context);
            }
            if (sink != null) {
                sink.close();
            }
        }
        catch (Throwable throwable) {
            if (sink != null) {
                sink.close();
            }
            IOUtil.close(jos);
            IOUtil.close((OutputStream)fos);
            throw throwable;
        }
        IOUtil.close((OutputStream)jos);
        IOUtil.close((OutputStream)fos);
    }

    protected void copyResources(JarOutputStream outputStream) throws IOException {
        File resourcesDirectory = new File(this.getBaseDir(), "resources");
        if (!resourcesDirectory.isDirectory()) {
            return;
        }
        this.copyDirectory(resourcesDirectory, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDirectory(File source, JarOutputStream destination) throws IOException {
        if (source.isDirectory()) {
            DirectoryScanner scanner = new DirectoryScanner();
            String[] includedResources = new String[]{"**/**"};
            scanner.setIncludes(includedResources);
            scanner.addDefaultExcludes();
            scanner.setBasedir(source);
            scanner.scan();
            List<String> includedFiles = Arrays.asList(scanner.getIncludedFiles());
            for (String name : includedFiles) {
                File sourceFile = new File(source, name);
                destination.putNextEntry(new JarEntry(name));
                FileInputStream input = null;
                try {
                    input = new FileInputStream(sourceFile);
                    IOUtil.copy((InputStream)input, (OutputStream)destination);
                }
                catch (Throwable throwable) {
                    IOUtil.close(input);
                    throw throwable;
                }
                IOUtil.close((InputStream)input);
            }
        }
    }

    private void mergeAllSources(Map<String, SiteModule> filesToProcess, JarXhtmlSink sink, DocumentRendererContext context) throws DocumentRendererException, IOException {
        ArrayList<ContentFile> content = new ArrayList<ContentFile>(filesToProcess.size());
        for (Map.Entry<String, SiteModule> entry : filesToProcess.entrySet()) {
            String key = entry.getKey();
            SiteModule module = entry.getValue();
            File fullDoc = new File(this.getBaseDir(), module.getSourceDirectory() + File.separator + key);
            DocumentTOCItem tocItem = new DocumentTOCItem();
            tocItem.setRef(key);
            tocItem.setName(null);
            content.add(new ContentFile(tocItem, entry.getValue(), fullDoc));
        }
        this.renderContentFiles(sink, context, content);
    }

    private void mergeSourcesFromTOC(DocumentTOC toc, JarXhtmlSink sink, DocumentRendererContext context) throws IOException, DocumentRendererException {
        ArrayList<ContentFile> content = new ArrayList<ContentFile>();
        this.parseTocItems(content, toc.getItems());
        this.renderContentFiles(sink, context, content);
    }

    private void renderContentFiles(JarXhtmlSink sink, DocumentRendererContext context, List<ContentFile> content) throws IOException, DocumentRendererException {
        if (content.isEmpty()) {
            return;
        }
        Iterator<ContentFile> iterator = content.iterator();
        ContentFile contentFile = iterator.next();
        while (contentFile != null) {
            ContentFile nextFile = iterator.hasNext() ? iterator.next() : null;
            sink.file(contentFile.getTocItem().getRef(), contentFile.getSource().lastModified(), contentFile.getTocItem().getName(), nextFile != null ? nextFile.getTocItem().getRef() : null);
            this.parse(contentFile.getSource().getPath(), contentFile.getModule().getParserId(), (Sink)sink, context);
            sink.file_();
            contentFile = nextFile;
        }
    }

    private void parseTocItems(List<ContentFile> content, List<DocumentTOCItem> items) throws IOException, DocumentRendererException {
        for (DocumentTOCItem tocItem : items) {
            if (tocItem.getRef() == null) {
                if (!this.getLogger().isInfoEnabled()) continue;
                this.getLogger().info("No ref defined for tocItem " + tocItem.getName());
                continue;
            }
            String href = StringUtils.replace((String)tocItem.getRef(), (String)"\\", (String)"/");
            if (href.lastIndexOf(46) != -1) {
                href = href.substring(0, href.lastIndexOf(46));
            }
            this.renderModules(content, href, tocItem);
            if (tocItem.getItems() == null) continue;
            this.parseTocItems(content, tocItem.getItems());
        }
    }

    private void renderModules(List<ContentFile> content, String href, DocumentTOCItem tocItem) throws DocumentRendererException, IOException {
        Collection modules = this.siteModuleManager.getSiteModules();
        for (SiteModule module : modules) {
            File moduleBasedir = new File(this.getBaseDir(), module.getSourceDirectory());
            if (!moduleBasedir.exists()) continue;
            String doc = href + "." + module.getExtension();
            File source = new File(moduleBasedir, doc);
            if (!source.exists()) {
                doc = href.indexOf("." + module.getExtension()) != -1 ? href + ".vm" : href + "." + module.getExtension() + ".vm";
                source = new File(moduleBasedir, doc);
            }
            if (!source.exists()) continue;
            content.add(new ContentFile(tocItem, module, source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTocXml(JarXhtmlSink sink, DocumentModel model, DocumentRendererContext context) throws IOException {
        JarOutputStream outputStream = sink.getOutputStream();
        outputStream.putNextEntry(new JarEntry("toc.xml"));
        PrintWriter pw = new PrintWriter(outputStream);
        try {
            PrettyPrintXMLWriter w = new PrettyPrintXMLWriter(pw, "  ", "\n", "UTF-8", null);
            w.startElement("toc");
            w.addAttribute("label", model.getCover().getCoverTitle());
            w.addAttribute("topic", "_toc.html");
            this.writeTocItems((XMLWriter)w, model.getToc().getItems());
            w.endElement();
        }
        finally {
            pw.flush();
        }
    }

    private void writeTocItems(XMLWriter w, List<DocumentTOCItem> items) {
        if (items != null) {
            for (DocumentTOCItem item : items) {
                w.startElement("topic");
                w.addAttribute("label", item.getName());
                w.addAttribute("href", item.getRef());
                this.writeTocItems(w, item.getItems());
                w.endElement();
            }
        }
    }

    private void renderTocXhtml(JarXhtmlSink sink, DocumentModel model, DocumentRendererContext context) throws IOException {
        sink.file("_toc.html", System.currentTimeMillis(), model.getToc().getName(), model.getToc().getItems().isEmpty() ? null : ((DocumentTOCItem)model.getToc().getItems().iterator().next()).getRef());
        sink.head();
        sink.title();
        sink.text(model.getToc().getName());
        sink.title_();
        sink.head_();
        sink.body();
        sink.toc(model.getToc());
        sink.body_();
        sink.file_();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPluginXml(JarXhtmlSink sink, DocumentModel model, DocumentRendererContext context) throws IOException {
        JarOutputStream outputStream = sink.getOutputStream();
        outputStream.putNextEntry(new JarEntry("plugin.xml"));
        PrintWriter pw = new PrintWriter(outputStream);
        try {
            PrettyPrintXMLWriter w = new PrettyPrintXMLWriter(pw, "  ", "\n", "UTF-8", null);
            w.startElement("plugin");
            w.addAttribute("name", model.getCover().getCoverTitle());
            w.addAttribute("id", "");
            w.addAttribute("version", model.getCover().getCoverVersion());
            w.addAttribute("provider-name", StringUtils.defaultString((Object)model.getCover().getCompanyName()));
            w.startElement("extension");
            w.addAttribute("point", "org.eclipse.help.toc");
            w.startElement("toc");
            w.addAttribute("file", "toc.xml");
            w.addAttribute("primary", "true");
            w.endElement();
            w.endElement();
            w.endElement();
        }
        finally {
            pw.flush();
        }
    }

    private static class ContentFile {
        private final DocumentTOCItem tocItem;
        private final SiteModule module;
        private final File source;

        private ContentFile(DocumentTOCItem tocItem, SiteModule module, File source) {
            this.tocItem = tocItem;
            this.module = module;
            this.source = source;
        }

        public DocumentTOCItem getTocItem() {
            return this.tocItem;
        }

        public SiteModule getModule() {
            return this.module;
        }

        public File getSource() {
            return this.source;
        }
    }
}

