/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.maven;

import java.io.File;
import java.io.IOException;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.pdf.PdfRenderer;
import org.apache.maven.doxia.docrenderer.pdf.fo.FoPdfRenderer;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.tobarsegais.maven.AbstractGenerateMojo;

@Mojo(name="pdf", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class GeneratePDFMojo
extends AbstractGenerateMojo {
    @Parameter(defaultValue="${project.build.directory}/${project.build.finalName}-docs.pdf")
    private File outputFile;
    @Component(role=PdfRenderer.class, hint="fo")
    private FoPdfRenderer renderer;

    protected void render(DocumentModel model) throws DocumentRendererException, IOException {
        this.renderer.render(this.sourceDirectory, this.outputFile.getParentFile(), model);
        this.projectHelper.attachArtifact(this.project, "pdf", "docs", this.outputFile);
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public FoPdfRenderer getRenderer() {
        return this.renderer;
    }
}

