/*
 * Decompiled with CFR 0.152.
 */
package org.tobarsegais.maven.model.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;
import org.tobarsegais.maven.model.BundleFile;
import org.tobarsegais.maven.model.BundleModel;

public class BundleXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, BundleModel bundleModel) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(bundleModel.getModelEncoding(), null);
        this.writeBundleModel(bundleModel, "bundle", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, BundleModel bundleModel) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, bundleModel.getModelEncoding());
        serializer.startDocument(bundleModel.getModelEncoding(), null);
        this.writeBundleModel(bundleModel, "bundle", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeBundleFile(BundleFile bundleFile, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (bundleFile.getSrc() != null) {
            serializer.attribute(NAMESPACE, "src", bundleFile.getSrc());
        }
        if (bundleFile.getTitle() != null) {
            serializer.attribute(NAMESPACE, "title", bundleFile.getTitle());
        }
        if (bundleFile.getFiles() != null && bundleFile.getFiles().size() > 0) {
            for (BundleFile o : bundleFile.getFiles()) {
                this.writeBundleFile(o, "file", serializer);
            }
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeBundleModel(BundleModel bundleModel, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (bundleModel.getFiles() != null && bundleModel.getFiles().size() > 0) {
            for (BundleFile o : bundleModel.getFiles()) {
                this.writeBundleFile(o, "file", serializer);
            }
        }
        if (bundleModel.getTitle() != null) {
            serializer.startTag(NAMESPACE, "title").text(bundleModel.getTitle()).endTag(NAMESPACE, "title");
        }
        if (bundleModel.getSubject() != null) {
            serializer.startTag(NAMESPACE, "subject").text(bundleModel.getSubject()).endTag(NAMESPACE, "subject");
        }
        if (bundleModel.getVersion() != null) {
            serializer.startTag(NAMESPACE, "version").text(bundleModel.getVersion()).endTag(NAMESPACE, "version");
        }
        if (bundleModel.getDescription() != null) {
            serializer.startTag(NAMESPACE, "description").text(bundleModel.getDescription()).endTag(NAMESPACE, "description");
        }
        if (bundleModel.getProjectName() != null) {
            serializer.startTag(NAMESPACE, "projectName").text(bundleModel.getProjectName()).endTag(NAMESPACE, "projectName");
        }
        if (bundleModel.getProjectLogo() != null) {
            serializer.startTag(NAMESPACE, "projectLogo").text(bundleModel.getProjectLogo()).endTag(NAMESPACE, "projectLogo");
        }
        if (bundleModel.getCompanyName() != null) {
            serializer.startTag(NAMESPACE, "companyName").text(bundleModel.getCompanyName()).endTag(NAMESPACE, "companyName");
        }
        if (bundleModel.getCompanyLogo() != null) {
            serializer.startTag(NAMESPACE, "companyLogo").text(bundleModel.getCompanyLogo()).endTag(NAMESPACE, "companyLogo");
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

