/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.cdi.spi;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.togglz.core.spi.BeanFinder;

public class CDIBeanFinder
implements BeanFinder {
    public static final String BEAN_MANAGER_JNDI = "java:comp/BeanManager";
    public static final String BEAN_MANAGER_JNDI_TOMCAT = "java:comp/env/BeanManager";
    public static final String SERVLET_CONTEXT_ATTR_WELD_1_1 = "org.jboss.weld.environment.servlet.javax.enterprise.inject.spi.BeanManager";

    public <T> Collection<T> find(Class<T> clazz, Object context) {
        BeanManager manager;
        ArrayList<Object> result = new ArrayList<Object>();
        ServletContext servletContext = null;
        if (context instanceof ServletContext) {
            servletContext = (ServletContext)context;
        }
        if ((manager = this.getBeanManager(servletContext)) != null) {
            Set beans = manager.getBeans(clazz, new Annotation[0]);
            for (Bean bean : beans) {
                CreationalContext cc = manager.createCreationalContext((Contextual)bean);
                Object reference = manager.getReference(bean, clazz, cc);
                result.add(reference);
            }
        }
        return result;
    }

    private BeanManager getBeanManager(ServletContext servletContext) {
        BeanManager beanManager = null;
        if (servletContext != null) {
            beanManager = (BeanManager)servletContext.getAttribute(BeanManager.class.getName());
        }
        if (beanManager == null && servletContext != null) {
            beanManager = (BeanManager)servletContext.getAttribute(SERVLET_CONTEXT_ATTR_WELD_1_1);
        }
        if (beanManager == null) {
            beanManager = this.getBeanManagerFromJNDI(BEAN_MANAGER_JNDI);
        }
        if (beanManager == null) {
            beanManager = this.getBeanManagerFromJNDI(BEAN_MANAGER_JNDI_TOMCAT);
        }
        return beanManager;
    }

    private BeanManager getBeanManagerFromJNDI(String jndiName) {
        try {
            InitialContext initialContext = new InitialContext();
            return (BeanManager)initialContext.lookup(jndiName);
        }
        catch (NamingException e) {
            return null;
        }
    }
}

