/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class HazelcastStateRepository
implements StateRepository {
    protected final HazelcastInstance hazelcastInstance;
    protected final Config hazelcastConfig;
    protected final String mapName;

    public HazelcastStateRepository(Config hazelcastConfig, String mapName) {
        this.mapName = mapName;
        this.hazelcastConfig = hazelcastConfig;
        this.hazelcastInstance = this.createHazelcastInstance();
    }

    private HazelcastStateRepository(Builder builder) {
        this.mapName = builder.mapName;
        this.hazelcastConfig = builder.hazelcastConfig;
        this.hazelcastInstance = this.createHazelcastInstance();
    }

    private HazelcastInstance createHazelcastInstance() {
        return this.hazelcastConfig != null ? Hazelcast.newHazelcastInstance((Config)this.hazelcastConfig) : Hazelcast.newHazelcastInstance();
    }

    public FeatureState getFeatureState(Feature feature) {
        IMap map = this.hazelcastInstance.getMap(this.mapName);
        return (FeatureState)map.get((Object)feature);
    }

    public void setFeatureState(FeatureState featureState) {
        IMap map = this.hazelcastInstance.getMap(this.mapName);
        map.set((Object)featureState.getFeature(), (Object)featureState);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(String mapName) {
        return new Builder(mapName);
    }

    public static class Builder {
        private String mapName = "togglz";
        private Config hazelcastConfig = null;

        public Builder() {
        }

        public Builder(String mapName) {
            this.mapName = mapName;
        }

        public Builder(Config hazelcastConfig) {
            this.hazelcastConfig = hazelcastConfig;
        }

        public Builder mapName(String mapName) {
            this.mapName = mapName;
            return this;
        }

        public Builder config(Config hazelcastConfig) {
            this.hazelcastConfig = hazelcastConfig;
            return this;
        }

        public HazelcastStateRepository build() {
            return new HazelcastStateRepository(this);
        }
    }
}

