/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.slack.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.util.MoreObjects;
import org.togglz.core.util.Preconditions;
import org.togglz.core.util.Strings;
import org.togglz.slack.config.NotificationConfigurationBuilder;

public class NotificationConfiguration {
    private static final List<String> DEFAULT_CHANNELS = Collections.singletonList("toggles");
    private static final List<String> DEFAULT_STATE_ICONS = Arrays.asList("large_blue_circle", "white_circle");
    private static final List<String> DEFAULT_CHANGE_VERBS = Arrays.asList("enabled", "disabled");
    private static final String DEFAULT_APP_ICON = "joystick";
    private final String slackHookUrl;
    private final List<String> channels;
    private final String togglzAdminConsoleUrl;
    private final String appName;
    private final String messageFormat;
    private final String appIcon;
    private final List<String> stateIcons;
    private final List<String> changeVerbs;
    private final boolean asyncSenderDisabled;
    private final boolean labelingEnabled;

    public static NotificationConfigurationBuilder builder() {
        return new NotificationConfigurationBuilder();
    }

    NotificationConfiguration(String slackHookUrl, List<String> channels, String togglzAdminConsoleUrl, String appName, String messageFormat, String appIcon, List<String> stateIcons, List<String> changeVerbs, boolean asyncSenderDisabled, boolean labelingEnabled) {
        Preconditions.checkArgument((boolean)Strings.isNotBlank((String)slackHookUrl), (Object)"slackHookUrl is required");
        Preconditions.checkArgument((boolean)slackHookUrl.startsWith("http"), (String)"slackHookUrl isn't valid url: %s", (Object[])new Object[]{slackHookUrl});
        this.slackHookUrl = slackHookUrl;
        this.channels = channels != null ? new LinkedList<String>(channels) : DEFAULT_CHANNELS;
        this.togglzAdminConsoleUrl = (String)MoreObjects.firstNonNull((Object)togglzAdminConsoleUrl, (Object)"");
        this.appName = (String)MoreObjects.firstNonNull((Object)appName, (Object)"");
        this.messageFormat = (String)MoreObjects.firstNonNull((Object)messageFormat, (Object)"$stateIcon *$feature* was $changed by $user $link");
        this.appIcon = (String)MoreObjects.firstNonNull((Object)appIcon, (Object)DEFAULT_APP_ICON);
        this.stateIcons = stateIcons != null ? new LinkedList<String>(stateIcons) : DEFAULT_STATE_ICONS;
        this.changeVerbs = changeVerbs != null ? new LinkedList<String>(changeVerbs) : DEFAULT_CHANGE_VERBS;
        this.asyncSenderDisabled = asyncSenderDisabled;
        this.labelingEnabled = labelingEnabled;
    }

    public String getSlackHookUrl() {
        return this.slackHookUrl;
    }

    public List<String> getChannels() {
        return this.channels;
    }

    public String getTogglzAdminConsoleUrl() {
        return this.togglzAdminConsoleUrl;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public String getAppIcon() {
        return this.appIcon;
    }

    public String getStateIcon(FeatureState state) {
        return this.stateIcons.get(state.isEnabled() ? 0 : 1);
    }

    public String getChangeVerb(FeatureState state) {
        return this.changeVerbs.get(state.isEnabled() ? 0 : 1);
    }

    public boolean isAsyncSenderDisabled() {
        return this.asyncSenderDisabled;
    }

    public boolean isLabelingEnabled() {
        return this.labelingEnabled;
    }
}

