/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.slack.sender;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.togglz.core.logging.Log;
import org.togglz.core.logging.LogFactory;
import org.togglz.core.util.Strings;
import org.togglz.slack.notification.Notification;
import org.togglz.slack.sender.HttpPostRequest;
import org.togglz.slack.sender.NotificationSender;

public class Notifier
implements NotificationSender {
    private static final Log log = LogFactory.getLog(Notifier.class);
    private final HttpPostRequest httpPostRequest;
    private final ObjectMapper mapper;

    public Notifier(String slackHookUrl) {
        this.httpPostRequest = new HttpPostRequest(slackHookUrl);
        this.mapper = new ObjectMapper();
    }

    @Override
    public void send(Notification notification) {
        String response;
        byte[] json = this.toJsonAsBytes(notification);
        if (json != null && Strings.isNotBlank((String)(response = this.httpPostRequest.send(json)))) {
            log.debug(response);
        }
    }

    private byte[] toJsonAsBytes(Notification notification) {
        try {
            return this.mapper.writeValueAsBytes((Object)notification);
        }
        catch (JsonProcessingException e) {
            log.error(e.toString(), (Throwable)e);
            return null;
        }
    }
}

