/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.slack.notification;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.user.UserProvider;
import org.togglz.core.util.FeatureAnnotations;
import org.togglz.core.util.Preconditions;
import org.togglz.core.util.Strings;
import org.togglz.slack.config.NotificationConfiguration;
import org.togglz.slack.notification.EmojiIcon;
import org.togglz.slack.notification.Markdown;
import org.togglz.slack.notification.Notification;
import org.togglz.slack.notification.Replacement;

public class NotificationComposer {
    public static final String DEFAULT_MESSAGE_FORMAT = "$stateIcon *$feature* was $changed by $user $link";
    private static final String SENDER_SUFFIX = "feature toggles";
    private final NotificationConfiguration configuration;
    private final UserProvider userProvider;

    public NotificationComposer(NotificationConfiguration configuration, UserProvider userProvider) {
        Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (Object)"configuration is null");
        Preconditions.checkArgument((userProvider != null ? 1 : 0) != 0, (Object)"userProvider is null");
        this.configuration = configuration;
        this.userProvider = userProvider;
    }

    public List<Notification> compose(FeatureState state, List<String> channels) {
        String message = this.getMessage(state);
        String appIcon = EmojiIcon.format(this.configuration.getAppIcon());
        String sender = this.getSender();
        LinkedList<Notification> notifications = new LinkedList<Notification>();
        for (String channel : channels) {
            if (!Strings.isNotBlank((String)channel)) continue;
            Notification notification = this.createNotification(message, appIcon, sender, channel);
            notifications.add(notification);
        }
        return notifications;
    }

    private Notification createNotification(String message, String appIcon, String sender, String channel) {
        Notification notification = new Notification();
        notification.setChannel(channel);
        notification.setUsername(sender);
        notification.setText(message);
        notification.setIcon(appIcon);
        notification.setMarkdown(true);
        return notification;
    }

    private String getMessage(final FeatureState state) {
        HashMap<String, String> values = new HashMap<String, String>(){
            {
                this.put("stateIcon", EmojiIcon.format(NotificationComposer.this.configuration.getStateIcon(state)));
                this.put("feature", state.getFeature().name());
                this.put("changed", NotificationComposer.this.configuration.getChangeVerb(state));
                this.put("user", NotificationComposer.this.getUsername());
                this.put("link", NotificationComposer.this.getLink());
            }
        };
        String format = this.configuration.getMessageFormat();
        if (this.configuration.isLabelingEnabled()) {
            format = this.appendLine(format, this.formatLabel(state));
        }
        Replacement replacement = new Replacement((Map<String, String>)values, "$");
        return replacement.replace(format);
    }

    private String getUsername() {
        String name = this.userProvider.getCurrentUser().getName();
        return this.isFullName(name) ? Markdown.linkName(name) : String.valueOf(name);
    }

    private boolean isFullName(String name) {
        return name != null && name.contains(".");
    }

    private String getSender() {
        return this.getAppName() + " " + SENDER_SUFFIX;
    }

    private String getAppName() {
        return this.configuration.getAppName();
    }

    private String getLink() {
        String adminConsoleUrl = this.configuration.getTogglzAdminConsoleUrl();
        if (Strings.isNotBlank((String)adminConsoleUrl)) {
            return Markdown.link(adminConsoleUrl, adminConsoleUrl);
        }
        return "";
    }

    private String formatLabel(FeatureState state) {
        String label = FeatureAnnotations.getLabel((Feature)state.getFeature());
        return Markdown.PRE.format(label);
    }

    private String appendLine(String text, String line) {
        return text + "\n" + line;
    }
}

