/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.slack.sender;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.togglz.core.logging.Log;
import org.togglz.core.logging.LogFactory;
import org.togglz.core.util.IOUtils;

class HttpPostRequest {
    private static final Log log = LogFactory.getLog(HttpPostRequest.class);
    private static final Long TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private final String requestUrl;

    HttpPostRequest(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String send(byte[] body) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(this.requestUrl);
            connection = this.prepareConnection(url, body);
            this.writeRequest(body, connection);
            String string = this.readResponse(connection);
            return string;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private HttpURLConnection prepareConnection(URL url, byte[] body) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Content-Length", Integer.toString(body.length));
        connection.setConnectTimeout(TIMEOUT.intValue());
        connection.setReadTimeout(TIMEOUT.intValue());
        return connection;
    }

    private void writeRequest(byte[] body, HttpURLConnection connection) throws IOException {
        ByteArrayInputStream input = new ByteArrayInputStream(body);
        IOUtils.copy((InputStream)input, (OutputStream)connection.getOutputStream());
    }

    private String readResponse(HttpURLConnection connection) throws IOException {
        InputStream inputStream = connection.getInputStream();
        return IOUtils.toString((Readable)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }
}

