/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.slack.notification;

import java.util.Arrays;
import org.togglz.core.util.Strings;

public enum Markdown {
    BOLD("*"),
    CODE("`"),
    ITALIC("_"),
    STRIKE("~"),
    PRE("```");

    private final String tag;

    private Markdown(String tag) {
        this.tag = tag;
    }

    public String format(String text) {
        return Strings.isBlank((String)text) ? "" : Markdown.concat(this.tag, text, this.tag);
    }

    public static String link(String url, String name) {
        String urlText;
        String string = urlText = Strings.isNotBlank((String)url) ? url.trim() : "";
        if (!urlText.isEmpty()) {
            String nameText = Strings.isNotBlank((String)name) ? name : urlText;
            return Markdown.concat("<", urlText, "|", nameText, ">");
        }
        return name;
    }

    public static String linkName(String name) {
        return "<@" + name + ">";
    }

    private static String concat(String ... strings) {
        return Strings.join(Arrays.asList(strings), (String)"");
    }
}

