/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.slack.sender;

import java.util.concurrent.Executor;
import org.togglz.slack.notification.Notification;
import org.togglz.slack.sender.ExecutorServiceFactory;
import org.togglz.slack.sender.NotificationSender;
import org.togglz.slack.sender.Notifier;

public class AsyncNotifier
implements NotificationSender {
    private final NotificationSender delegate;
    private final Executor executor;

    public AsyncNotifier(String slackHookUrl) {
        this(slackHookUrl, ExecutorServiceFactory.createSingleThreadExecutor());
    }

    public AsyncNotifier(String slackHookUrl, Executor executor) {
        this.delegate = new Notifier(slackHookUrl);
        this.executor = executor;
    }

    @Override
    public void send(final Notification notification) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                AsyncNotifier.this.delegate.send(notification);
            }
        });
    }
}

