/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.slack;

import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.user.SingleUserProvider;
import org.togglz.core.user.UserProvider;
import org.togglz.slack.SlackNotifications;
import org.togglz.slack.config.NotificationConfiguration;

public class SlackStateRepository
implements StateRepository {
    private final StateRepository wrappedRepository;
    private final SlackNotifications slackNotifications;

    public SlackStateRepository(StateRepository wrappedRepository, NotificationConfiguration configuration, UserProvider userProvider) {
        this(wrappedRepository, new SlackNotifications(configuration, userProvider));
    }

    public SlackStateRepository(StateRepository wrappedRepository, NotificationConfiguration configuration) {
        this(wrappedRepository, new SlackNotifications(configuration, (UserProvider)new SingleUserProvider("unknown")));
    }

    public SlackStateRepository(StateRepository wrappedRepository, SlackNotifications slackNotifications) {
        this.wrappedRepository = wrappedRepository;
        this.slackNotifications = slackNotifications;
    }

    public FeatureState getFeatureState(Feature feature) {
        return this.wrappedRepository.getFeatureState(feature);
    }

    public void setFeatureState(FeatureState featureState) {
        this.wrappedRepository.setFeatureState(featureState);
        this.slackNotifications.notify(featureState);
    }
}

