/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.slack.config;

import java.util.Arrays;
import java.util.List;
import org.togglz.slack.config.NotificationConfiguration;

public final class NotificationConfigurationBuilder {
    private String slackHookUrl;
    private List<String> channels;
    private String togglzAdminConsoleUrl;
    private String appName;
    private String messageFormat;
    private String appIcon;
    private List<String> statesIcons;
    private List<String> changeVerbs;
    private boolean asyncSenderDisabled;
    private boolean labelingEnabled;

    public NotificationConfigurationBuilder withSlackHookUrl(String slackHookUrl) {
        this.slackHookUrl = slackHookUrl;
        return this;
    }

    public NotificationConfigurationBuilder withChannels(String ... channels) {
        this.channels = Arrays.asList(channels);
        return this;
    }

    public NotificationConfigurationBuilder withTogglzAdminConsoleUrl(String togglzAdminConsoleUrl) {
        this.togglzAdminConsoleUrl = togglzAdminConsoleUrl;
        return this;
    }

    public NotificationConfigurationBuilder withAppName(String appName) {
        this.appName = appName;
        return this;
    }

    public NotificationConfigurationBuilder withMessageFormat(String messageFormat) {
        this.messageFormat = messageFormat;
        return this;
    }

    public NotificationConfigurationBuilder withAppIcon(String appIcon) {
        this.appIcon = appIcon;
        return this;
    }

    public NotificationConfigurationBuilder withStatesIcons(String enabled, String disabled) {
        this.statesIcons = Arrays.asList(enabled, disabled);
        return this;
    }

    public NotificationConfigurationBuilder withChangeVerbs(String enabled, String disabled) {
        this.changeVerbs = Arrays.asList(enabled, disabled);
        return this;
    }

    public NotificationConfigurationBuilder disableAsyncSender() {
        this.asyncSenderDisabled = true;
        return this;
    }

    public NotificationConfigurationBuilder enableLabeling() {
        this.labelingEnabled = true;
        return this;
    }

    public NotificationConfiguration build() {
        return new NotificationConfiguration(this.slackHookUrl, this.channels, this.togglzAdminConsoleUrl, this.appName, this.messageFormat, this.appIcon, this.statesIcons, this.changeVerbs, this.asyncSenderDisabled, this.labelingEnabled);
    }
}

