/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spock;

import groovy.lang.Closure;
import java.util.List;
import java.util.Objects;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.PreconditionContext;
import org.togglz.core.Feature;
import org.togglz.core.context.FeatureContext;
import org.togglz.core.manager.FeatureManager;
import org.togglz.spock.Togglz;
import org.togglz.testing.TestFeatureManager;
import org.togglz.testing.TestFeatureManagerProvider;

public class TogglzInterceptor
implements IMethodInterceptor {
    private Class<? extends Feature> allEnabled = null;
    private Class<? extends Feature> allDisabled = null;
    private Class<? extends Closure<List<? extends Feature>>> enable = null;
    private Class<? extends Closure<List<? extends Feature>>> disable = null;

    TogglzInterceptor(Togglz specAnnotation, Togglz featureAnnotation) {
        if (specAnnotation == null) {
            this.assign(this.validate(Objects.requireNonNull(featureAnnotation, "At least one of specAnnotation and featureAnnotation must be non-null")));
        } else if (featureAnnotation == null) {
            this.assign(this.validate(Objects.requireNonNull(specAnnotation, "At least one of specAnnotation and featureAnnotation must be non-null")));
        } else {
            this.merge(this.validate(specAnnotation), this.validate(featureAnnotation));
        }
        if (this.allEnabled == null && this.allDisabled == null) {
            throw new IllegalArgumentException("One of allEnabled or allDisabled must be set");
        }
        if (this.allEnabled != null && this.enable != null) {
            throw new IllegalArgumentException("You cannot combine allEnable with enable");
        }
        if (this.allDisabled != null && this.disable != null) {
            throw new IllegalArgumentException("You cannot combine allDisabled with allDisabled");
        }
    }

    private Togglz validate(Togglz annotation) {
        if (this.isSet(annotation.allEnabled()) && this.isSet(annotation.allDisabled())) {
            throw new IllegalArgumentException("Only one of allEnabled or allDisabled must be set");
        }
        return annotation;
    }

    private boolean isNone(Class<?> cls) {
        return Togglz.None.class.equals(cls);
    }

    private boolean isSet(Class<?> cls) {
        return !this.isNone(cls);
    }

    private void assign(Togglz annotation) {
        this.assignFeatureClass(annotation);
        this.assignClosure(annotation);
    }

    private void assignFeatureClass(Togglz annotation) {
        this.allEnabled = this.isNone(annotation.allEnabled()) ? null : annotation.allEnabled();
        this.allDisabled = this.isNone(annotation.allDisabled()) ? null : annotation.allDisabled();
    }

    private void assignClosure(Togglz annotation) {
        this.enable = this.isNone(annotation.enable()) ? null : annotation.enable();
        this.disable = this.isNone(annotation.disable()) ? null : annotation.disable();
    }

    private void merge(Togglz specAnnotation, Togglz featureAnnotation) {
        if (this.isSet(featureAnnotation.allEnabled())) {
            this.allEnabled = featureAnnotation.allEnabled();
        } else if (this.isSet(featureAnnotation.allDisabled())) {
            this.allDisabled = featureAnnotation.allDisabled();
        } else {
            this.assignFeatureClass(specAnnotation);
        }
        if (this.isSet(featureAnnotation.enable())) {
            this.enable = featureAnnotation.enable();
        } else if (this.isSet(featureAnnotation.disable())) {
            this.disable = featureAnnotation.disable();
        } else {
            this.assignClosure(specAnnotation);
        }
    }

    private TestFeatureManager createTestFeatureManager() {
        TestFeatureManager featureManager = null;
        if (this.allEnabled != null) {
            featureManager = new TestFeatureManager(this.allEnabled);
            featureManager.enableAll();
        } else if (this.allDisabled != null) {
            featureManager = new TestFeatureManager(this.allDisabled);
            featureManager.disableAll();
        }
        return featureManager;
    }

    private void applyEnableDisable(TestFeatureManager featureManager, Object instance) {
        if (this.enable != null) {
            List<? extends Feature> features = this.evaluate(this.enable, instance);
            features.forEach(arg_0 -> ((TestFeatureManager)featureManager).enable(arg_0));
        } else if (this.disable != null) {
            List<? extends Feature> features = this.evaluate(this.disable, instance);
            features.forEach(arg_0 -> ((TestFeatureManager)featureManager).disable(arg_0));
        }
    }

    private List<? extends Feature> evaluate(Class<? extends Closure<List<? extends Feature>>> closureClass, Object instance) {
        PreconditionContext preconditionContext = new PreconditionContext();
        Closure<List<? extends Feature>> closure = this.instantiateClosure(closureClass, instance);
        closure.setDelegate((Object)preconditionContext);
        closure.setResolveStrategy(1);
        return (List)closure.call((Object)preconditionContext);
    }

    public void intercept(IMethodInvocation invocation) throws Throwable {
        TestFeatureManager testFeatureManager = this.createTestFeatureManager();
        this.applyEnableDisable(testFeatureManager, invocation.getInstance());
        TestFeatureManagerProvider.setFeatureManager((FeatureManager)testFeatureManager);
        FeatureContext.clearCache();
        try {
            invocation.proceed();
        }
        finally {
            TestFeatureManagerProvider.setFeatureManager(null);
            FeatureContext.clearCache();
        }
    }

    Closure<List<? extends Feature>> instantiateClosure(Class<? extends Closure<List<? extends Feature>>> closureClass, Object instance) {
        try {
            return closureClass.getDeclaredConstructor(Object.class, Object.class).newInstance(instance, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not instantiate closure");
        }
    }
}

