/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spock;

import org.spockframework.runtime.extension.IAnnotationDrivenExtension;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.runtime.model.parallel.ExclusiveResource;
import org.spockframework.runtime.model.parallel.ResourceAccessMode;
import org.togglz.spock.Togglz;
import org.togglz.spock.TogglzInjectionInterceptor;
import org.togglz.spock.TogglzInterceptor;
import org.togglz.testing.TestFeatureManagerProvider;

public class TogglzExtension
implements IAnnotationDrivenExtension<Togglz> {
    public static final String TOGGLZ_FEATURE_RESOURCE = TestFeatureManagerProvider.class.getCanonicalName();
    private static final ExclusiveResource TOGGLZ_EXCLUSIVE_RESOURCE = new ExclusiveResource(TOGGLZ_FEATURE_RESOURCE, ResourceAccessMode.READ_WRITE);
    private static final TogglzInjectionInterceptor INJECTION_INTERCEPTOR = new TogglzInjectionInterceptor();

    public void visitSpecAnnotation(Togglz specAnnotation, SpecInfo spec) {
        if (!spec.getIsBottomSpec()) {
            return;
        }
        TogglzInterceptor specInterceptor = new TogglzInterceptor(specAnnotation, null);
        spec.addExclusiveResource(TOGGLZ_EXCLUSIVE_RESOURCE);
        spec.getAllFeatures().forEach(feature -> {
            Togglz featureAnnotation = (Togglz)feature.getFeatureMethod().getAnnotation(Togglz.class);
            TogglzInterceptor featureInterceptor = featureAnnotation == null ? specInterceptor : new TogglzInterceptor(specAnnotation, featureAnnotation);
            feature.addIterationInterceptor((IMethodInterceptor)featureInterceptor);
            feature.getFeatureMethod().addInterceptor((IMethodInterceptor)INJECTION_INTERCEPTOR);
        });
    }

    public void visitFeatureAnnotation(Togglz featureAnnotation, FeatureInfo feature) {
        if (feature.getSpec().isAnnotationPresent(Togglz.class)) {
            return;
        }
        feature.addExclusiveResource(TOGGLZ_EXCLUSIVE_RESOURCE);
        feature.addIterationInterceptor((IMethodInterceptor)new TogglzInterceptor(null, featureAnnotation));
        feature.getFeatureMethod().addInterceptor((IMethodInterceptor)INJECTION_INTERCEPTOR);
    }
}

