/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.security;

import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.user.SimpleFeatureUser;
import org.togglz.core.user.UserProvider;

public class SpringSecurityUserProvider
implements UserProvider {
    private final String featureAdminAuthority;

    public SpringSecurityUserProvider(String featureAdminAuthority) {
        this.featureAdminAuthority = featureAdminAuthority;
    }

    public FeatureUser getCurrentUser() {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (authentication != null) {
            String name = null;
            Object principal = authentication.getPrincipal();
            if (principal instanceof UserDetails) {
                UserDetails userDetails = (UserDetails)principal;
                name = userDetails.getUsername();
            } else {
                name = principal.toString();
            }
            boolean featureAdmin = false;
            if (this.featureAdminAuthority != null) {
                for (GrantedAuthority authority : authentication.getAuthorities()) {
                    if (!authority.getAuthority().equals(this.featureAdminAuthority)) continue;
                    featureAdmin = true;
                }
            }
            return new SimpleFeatureUser(name, featureAdmin);
        }
        return null;
    }
}

