/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.security;

import java.util.Collection;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.user.SimpleFeatureUser;
import org.togglz.core.user.UserProvider;

public class SpringSecurityUserProvider
implements UserProvider {
    public static final String USER_ATTRIBUTE_ROLES = "roles";
    private final String featureAdminAuthority;

    public SpringSecurityUserProvider(String featureAdminAuthority) {
        this.featureAdminAuthority = featureAdminAuthority;
    }

    public FeatureUser getCurrentUser() {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (authentication != null) {
            String name = null;
            Object principal = authentication.getPrincipal();
            if (principal instanceof UserDetails) {
                UserDetails userDetails = (UserDetails)principal;
                name = userDetails.getUsername();
            } else {
                name = principal.toString();
            }
            Set authorities = AuthorityUtils.authorityListToSet((Collection)authentication.getAuthorities());
            boolean featureAdmin = false;
            if (this.featureAdminAuthority != null) {
                featureAdmin = authorities.contains(this.featureAdminAuthority);
            }
            SimpleFeatureUser user = new SimpleFeatureUser(name, featureAdmin);
            user.setAttribute(USER_ATTRIBUTE_ROLES, (Object)authorities);
            return user;
        }
        return null;
    }
}

