/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.security;

import java.util.Collection;
import java.util.Set;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.user.SimpleFeatureUser;
import org.togglz.core.user.UserProvider;

public class SpringSecurityUserProvider
implements UserProvider {
    public static final String USER_ATTRIBUTE_ROLES = "roles";
    private final String featureAdminAuthority;

    public SpringSecurityUserProvider(String featureAdminAuthority) {
        this.featureAdminAuthority = featureAdminAuthority;
    }

    public FeatureUser getCurrentUser() {
        SecurityContext context = SecurityContextHolder.getContext();
        Authentication authentication = context.getAuthentication();
        if (authentication == null) {
            return null;
        }
        String name = this.getUserName(authentication);
        Set authorities = AuthorityUtils.authorityListToSet((Collection)authentication.getAuthorities());
        boolean featureAdmin = this.isFeatureAdmin(authorities);
        SimpleFeatureUser user = new SimpleFeatureUser(name, featureAdmin);
        user.setAttribute(USER_ATTRIBUTE_ROLES, (Object)authorities);
        return user;
    }

    private boolean isFeatureAdmin(Set<String> authorities) {
        return this.featureAdminAuthority != null && authorities.contains(this.featureAdminAuthority);
    }

    private String getUserName(Authentication authentication) {
        Object principal = authentication.getPrincipal();
        if (!(principal instanceof UserDetails)) {
            return principal.toString();
        }
        UserDetails userDetails = (UserDetails)principal;
        return userDetails.getUsername();
    }
}

