/*
 * Decompiled with CFR 0.152.
 */
package org.tomdz.maven.sphinx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PySystemState;

public class SphinxMojo
extends AbstractMavenReport {
    private MavenProject project;
    private File sourceDirectory;
    private File outputDirectory;
    private File sphinxSourceDirectory;
    private String builder;
    private boolean verbose;
    private boolean warningsAsErrors;
    private boolean force;

    public String getDescription(Locale defaultLocale) {
        return "Documentation via sphinx";
    }

    public String getName(Locale defaultLocale) {
        return "Documentation via sphinx";
    }

    public String getOutputName() {
        return "index";
    }

    public boolean isExternalReport() {
        return true;
    }

    protected Renderer getSiteRenderer() {
        return null;
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    public void execute() throws MojoExecutionException {
        try {
            this.executeReport(Locale.getDefault());
        }
        catch (MavenReportException ex) {
            throw new MojoExecutionException("Failed to run the report", (Exception)((Object)ex));
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        this.unpackSphinx();
        this.runSphinx();
    }

    private void unpackSphinx() throws MavenReportException {
        if (!this.sphinxSourceDirectory.exists() && !this.sphinxSourceDirectory.mkdirs()) {
            throw new MavenReportException("Could not generate the temporary directory " + this.sphinxSourceDirectory.getAbsolutePath() + " for the sphinx sources");
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)("Unpacking sphinx to " + this.sphinxSourceDirectory.getAbsolutePath()));
        }
        try {
            ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream("jar", SphinxMojo.class.getResourceAsStream("/sphinx.jar"));
            ArchiveEntry entry = input.getNextEntry();
            while (entry != null) {
                File archiveEntry = new File(this.sphinxSourceDirectory, entry.getName());
                archiveEntry.getParentFile().mkdirs();
                if (entry.isDirectory()) {
                    archiveEntry.mkdir();
                    entry = input.getNextEntry();
                    continue;
                }
                FileOutputStream out = new FileOutputStream(archiveEntry);
                IOUtils.copy((InputStream)input, (OutputStream)out);
                ((OutputStream)out).close();
                entry = input.getNextEntry();
            }
            input.close();
        }
        catch (Exception ex) {
            throw new MavenReportException("Could not unpack the sphinx source", ex);
        }
    }

    private void runSphinx() throws MavenReportException {
        PySystemState engineSys = new PySystemState();
        engineSys.path.append((PyObject)Py.newString((String)this.sphinxSourceDirectory.getAbsolutePath()));
        Py.setSystemState((PySystemState)engineSys);
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("python");
        if (this.verbose) {
            this.getLog().info((CharSequence)("Running sphinx on " + this.sourceDirectory.getAbsolutePath() + ", output will be placed in " + this.outputDirectory.getAbsolutePath()));
        }
        ArrayList<String> args = new ArrayList<String>();
        if (this.verbose) {
            args.add("-v");
        } else {
            args.add("-Q");
        }
        if (this.warningsAsErrors) {
            args.add("-W");
        }
        if (this.force) {
            args.add("-a");
            args.add("-E");
        }
        if (this.builder != null) {
            args.add("-b");
            args.add(this.builder);
        }
        args.add("-n");
        args.add(this.sourceDirectory.getAbsolutePath());
        args.add(this.outputDirectory.getAbsolutePath());
        engine.put("args", args.toArray(new String[args.size()]));
        try {
            engine.eval("import sphinx; sphinx.main(args)");
        }
        catch (ScriptException ex) {
            throw new MavenReportException("Could not generate documentation", (Exception)ex);
        }
    }
}

