/*
 * Decompiled with CFR 0.152.
 */
package org.tomdz.storm.esper;

import backtype.storm.generated.GlobalStreamId;
import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.IRichBolt;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.EPAdministrator;
import com.espertech.esper.client.EPRuntime;
import com.espertech.esper.client.EPServiceProvider;
import com.espertech.esper.client.EPServiceProviderManager;
import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EsperBolt
implements IRichBolt,
UpdateListener {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> inputAliases;
    private final Map<String, Fields> eventTypeFieldsMap;
    private final Map<String, Integer> eventTypeStreamIdMap;
    private final List<String> statements;
    private transient EPServiceProvider esperSink;
    private transient EPRuntime runtime;
    private transient EPAdministrator admin;
    private transient OutputCollector collector;
    private transient boolean singleEventType;

    private EsperBolt(Map<String, String> inputAliases, Map<String, Fields> eventTypeFieldsMap, Map<String, Integer> eventTypeStreamIdMap, List<String> statements) {
        this.inputAliases = new LinkedHashMap<String, String>(inputAliases);
        this.eventTypeFieldsMap = new LinkedHashMap<String, Fields>(eventTypeFieldsMap);
        this.eventTypeStreamIdMap = new LinkedHashMap<String, Integer>(eventTypeStreamIdMap);
        this.statements = new ArrayList<String>(statements);
    }

    public List<String> getEventTypes() {
        return new ArrayList<String>(this.eventTypeFieldsMap.keySet());
    }

    public Fields getFieldsForEventType(String eventType) {
        return this.eventTypeFieldsMap.get(eventType);
    }

    public Integer getStreamIdForEventType(String eventType) {
        return this.eventTypeStreamIdMap.get(eventType);
    }

    public String getEventTypeForStreamId(int streamId) {
        for (Map.Entry<String, Integer> entry : this.eventTypeStreamIdMap.entrySet()) {
            if (entry.getValue() != streamId) continue;
            return entry.getKey();
        }
        return null;
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        for (Map.Entry<String, Integer> entry : this.eventTypeStreamIdMap.entrySet()) {
            Fields fields = this.eventTypeFieldsMap.get(entry.getKey());
            declarer.declareStream(entry.getValue().intValue(), fields);
        }
    }

    public void prepare(Map conf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
        Configuration configuration = new Configuration();
        this.setupEventTypes(context, configuration);
        this.esperSink = EPServiceProviderManager.getDefaultProvider((Configuration)configuration);
        this.esperSink.initialize();
        this.runtime = this.esperSink.getEPRuntime();
        this.admin = this.esperSink.getEPAdministrator();
        for (String stmt : this.statements) {
            EPStatement statement = this.admin.createEPL(stmt);
            statement.addListener((UpdateListener)this);
        }
    }

    private String getEventTypeName(int componentId, int streamId) {
        String alias = this.inputAliases.get(componentId + "-" + streamId);
        if (alias == null) {
            alias = this.singleEventType ? "Storm" : String.format("Storm_%d_%d", componentId, streamId);
        }
        return alias;
    }

    private void setupEventTypes(TopologyContext context, Configuration configuration) {
        Set sourceIds = context.getThisSources().keySet();
        this.singleEventType = sourceIds.size() == 1;
        for (GlobalStreamId id : sourceIds) {
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            this.setupEventTypeProperties(context.getComponentOutputFields(id.get_componentId(), id.get_streamId()), props);
            configuration.addEventType(this.getEventTypeName(id.get_componentId(), id.get_streamId()), props);
        }
    }

    private void setupEventTypeProperties(Fields fields, Map<String, Object> properties) {
        int numFields = fields.size();
        for (int idx = 0; idx < numFields; ++idx) {
            properties.put(fields.get(idx), Object.class);
        }
    }

    public void execute(Tuple tuple) {
        String eventType = this.getEventTypeName(tuple.getSourceComponent(), tuple.getSourceStreamId());
        HashMap<String, Object> data = new HashMap<String, Object>();
        Fields fields = tuple.getFields();
        int numFields = fields.size();
        for (int idx = 0; idx < numFields; ++idx) {
            String name = fields.get(idx);
            Object value = tuple.getValue(idx);
            data.put(name, value);
        }
        this.runtime.sendEvent(data, eventType);
    }

    public void update(EventBean[] newEvents, EventBean[] oldEvents) {
        if (newEvents != null) {
            for (EventBean newEvent : newEvents) {
                String eventType = newEvent.getEventType().getName();
                Integer streamId = this.eventTypeStreamIdMap.get(eventType);
                if (streamId == null) {
                    eventType = null;
                    streamId = this.eventTypeStreamIdMap.get(null);
                }
                if (streamId == null) continue;
                Fields fields = this.eventTypeFieldsMap.get(eventType);
                this.collector.emit(streamId.intValue(), this.toTuple(newEvent, fields));
            }
        }
    }

    private List<Object> toTuple(EventBean event, Fields fields) {
        int numFields = fields.size();
        ArrayList<Object> tuple = new ArrayList<Object>(numFields);
        for (int idx = 0; idx < numFields; ++idx) {
            tuple.add(event.get(fields.get(idx)));
        }
        return tuple;
    }

    public void cleanup() {
        if (this.esperSink != null) {
            this.esperSink.destroy();
        }
    }

    public static final class Builder {
        private final Map<String, String> inputAliases = new LinkedHashMap<String, String>();
        private final Map<String, Fields> eventTypeFieldsMap = new LinkedHashMap<String, Fields>();
        private final Map<String, Integer> eventTypeStreamIdMap = new LinkedHashMap<String, Integer>();
        private final List<String> statements = new ArrayList<String>();

        public Builder addInputAlias(int componentId, int streamId, String name) {
            this.inputAliases.put(componentId + "-" + streamId, name);
            return this;
        }

        public Builder addNamedOutput(int streamId, String eventTypeName, String ... fields) {
            this.eventTypeFieldsMap.put(eventTypeName, new Fields(fields));
            this.eventTypeStreamIdMap.put(eventTypeName, streamId);
            return this;
        }

        public Builder setAnonymousOutput(int streamId, String ... fields) {
            this.eventTypeFieldsMap.put(null, new Fields(fields));
            this.eventTypeStreamIdMap.put(null, streamId);
            return this;
        }

        public Builder addStatement(String stmt) {
            this.statements.add(stmt);
            return this;
        }

        public EsperBolt build() {
            return new EsperBolt(this.inputAliases, this.eventTypeFieldsMap, this.eventTypeStreamIdMap, this.statements);
        }
    }
}

