/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.archie;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.tomitribe.archie.Digest;
import org.tomitribe.archie.DigestsInputStream;
import org.tomitribe.archie.DigestsOutputStream;
import org.tomitribe.util.IO;
import org.tomitribe.util.Join;

public class Binary
extends File {
    private final File md5 = new File(this.getAbsolutePath() + ".md5");
    private final File sha1 = new File(this.getAbsolutePath() + ".sha1");
    private final File sha256 = new File(this.getAbsolutePath() + ".sha256");

    public Binary(File parent, String child) {
        super(parent, child);
    }

    public Binary(File file) {
        super(file.getPath());
    }

    public Binary(String file) {
        super(file);
    }

    public BinaryOutputStream write() {
        return new BinaryOutputStream();
    }

    public BinaryInputStream read() {
        return new BinaryInputStream();
    }

    public String getMd5() {
        return this.content(this.md5);
    }

    public String getSha1() {
        return this.content(this.sha1);
    }

    public String getSha256() {
        return this.content(this.sha256);
    }

    public void verify() {
        if (!(this.md5.exists() || this.sha1.exists() || this.sha256.exists())) {
            throw new VerificationNotPossibleException(this, this.md5, this.sha1, this.sha256);
        }
        BinaryInputStream in = this.read();
        try {
            IO.copy((InputStream)in, (OutputStream)new Ignore());
        }
        catch (IOException e) {
            throw new ReadException(this, (Throwable)e);
        }
        if (this.md5.exists()) {
            this.verify("MD5", in.getMd5(), this.getMd5());
        }
        if (this.sha1.exists()) {
            this.verify("SHA-1", in.getSha1(), this.getSha1());
        }
        if (this.sha256.exists()) {
            this.verify("SHA-256", in.getSha256(), this.getSha256());
        }
    }

    public boolean verify(PrintStream ps) {
        if (!(this.md5.exists() || this.sha1.exists() || this.sha256.exists())) {
            ps.println(String.format("Unable to verify '%s'.  No digest files found.  Looked for: %s", this.getName(), Join.join((String)", ", File::getName, (Object[])new File[]{this.md5, this.sha1, this.sha256})));
            return false;
        }
        BinaryInputStream in = this.read();
        try {
            IO.copy((InputStream)in, (OutputStream)new Ignore());
        }
        catch (IOException e) {
            throw new ReadException(this, (Throwable)e);
        }
        boolean passed = true;
        if (this.md5.exists()) {
            boolean bl = passed = this.verify(ps, "MD5", in.getMd5(), this.getMd5()) && passed;
        }
        if (this.sha1.exists()) {
            boolean bl = passed = this.verify(ps, "SHA-1", in.getSha1(), this.getSha1()) && passed;
        }
        if (this.sha256.exists()) {
            passed = this.verify(ps, "SHA-256", in.getSha256(), this.getSha256()) && passed;
        }
        return passed;
    }

    private boolean verify(PrintStream ps, String algorithm, String actualHex, String expectedHex) {
        if (!expectedHex.equals(actualHex)) {
            ps.println(String.format("Verification failed %s.  Expected %s hash of %s, found %s", this.getName(), algorithm, expectedHex, actualHex));
            return false;
        }
        return true;
    }

    public void generate() {
        this.generate(false);
    }

    public void generate(boolean overwrite) {
        BinaryInputStream in = this.read();
        try {
            IO.copy((InputStream)in, (OutputStream)new Ignore());
        }
        catch (IOException e) {
            throw new ReadException(this, (Throwable)e);
        }
        if (!this.md5.exists() || overwrite) {
            try {
                IO.copy((String)in.getMd5(), (File)this.md5);
            }
            catch (IOException e) {
                throw new WriteException(this.md5, (Throwable)e);
            }
        }
        if (!this.sha1.exists() || overwrite) {
            try {
                IO.copy((String)in.getSha1(), (File)this.sha1);
            }
            catch (IOException e) {
                throw new WriteException(this.sha1, (Throwable)e);
            }
        }
        if (!this.sha256.exists() || overwrite) {
            try {
                IO.copy((String)in.getSha256(), (File)this.sha256);
            }
            catch (IOException e) {
                throw new WriteException(this.sha256, (Throwable)e);
            }
        }
    }

    private void verify(String algorithm, String actualHex, String expectedHex) {
        if (!expectedHex.equals(actualHex)) {
            throw new VerificationFailedException(this, algorithm, expectedHex, actualHex);
        }
    }

    private String content(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            return IO.slurp((File)file);
        }
        catch (IOException e) {
            throw new ReadException(file, (Throwable)e);
        }
    }

    public static Binary from(File file) {
        if (file instanceof Binary) {
            return (Binary)file;
        }
        return new Binary(file);
    }

    private static class Ignore
    extends OutputStream {
        private Ignore() {
        }

        @Override
        public void write(int b) throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
        }
    }

    public static class VerificationNotPossibleException
    extends RuntimeException {
        public VerificationNotPossibleException(File file, File ... digests) {
            super(String.format("Unable to verify '%s'.  No digest files found.  Looked for%n%s", file.getName(), Join.join((String)"\n", File::getName, (Object[])digests)));
        }
    }

    public static class VerificationFailedException
    extends RuntimeException {
        public VerificationFailedException(File file, String algorithm, String expectedHex, String actualHex) {
            super(String.format("Verification failed %s.  Expected %s hash of %s, found %s", file.getName(), algorithm, expectedHex, actualHex));
        }
    }

    public static class WriteException
    extends RuntimeException {
        public WriteException(File file, Throwable cause) {
            super(String.format("Unable to write '%s'", file.getAbsolutePath()), cause);
        }
    }

    public static class ReadException
    extends RuntimeException {
        public ReadException(File file, Throwable cause) {
            super(String.format("Unable to read '%s'", file.getAbsolutePath()), cause);
        }
    }

    public class BinaryInputStream
    extends InputStream {
        private final DigestsInputStream md5;
        private final DigestsInputStream sha1;
        private final DigestsInputStream sha256;
        private final InputStream in;

        public BinaryInputStream() {
            try {
                InputStream in = IO.read((File)Binary.this);
                this.md5 = new DigestsInputStream(in, Digest.MD5);
                this.sha1 = new DigestsInputStream(this.md5, Digest.SHA1);
                this.sha256 = new DigestsInputStream(this.sha1, Digest.SHA256);
                this.in = this.sha256;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.in.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        public String getMd5() {
            return this.md5.hex();
        }

        public String getSha1() {
            return this.sha1.hex();
        }

        public String getSha256() {
            return this.sha256.hex();
        }
    }

    public class BinaryOutputStream
    extends OutputStream {
        private final DigestsOutputStream md5;
        private final DigestsOutputStream sha1;
        private final DigestsOutputStream sha256;
        private final OutputStream out;

        public BinaryOutputStream() {
            try {
                OutputStream out = IO.write((File)Binary.this);
                this.md5 = new DigestsOutputStream(out, Digest.MD5);
                this.sha1 = new DigestsOutputStream(this.md5, Digest.SHA1);
                this.sha256 = new DigestsOutputStream(this.sha1, Digest.SHA256);
                this.out = this.sha256;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
            IO.copy((InputStream)IO.read((String)this.md5.hex()), (File)Binary.this.md5);
            IO.copy((InputStream)IO.read((String)this.sha1.hex()), (File)Binary.this.sha1);
            IO.copy((InputStream)IO.read((String)this.sha256.hex()), (File)Binary.this.sha256);
        }

        public String getMd5() {
            return this.md5.hex();
        }

        public String getSha1() {
            return this.sha1.hex();
        }

        public String getSha256() {
            return this.sha256.hex();
        }
    }
}

