/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.archie;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.tomitribe.archie.DigestsInputStream;
import org.tomitribe.archie.DigestsOutputStream;
import org.tomitribe.archie.NoSuchDigestAlgorithmException;
import org.tomitribe.util.IO;

public enum Digest {
    MD5("MD5"),
    SHA1("SHA-1"),
    SHA256("SHA-256");

    private final String algorithm;

    private Digest(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public MessageDigest digest() {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchDigestAlgorithmException(this.algorithm, e);
        }
    }

    public String digest(File file) {
        try {
            DigestsInputStream in = this.digest(IO.read((File)file));
            IO.copy((InputStream)in, (OutputStream)OutputStream.nullOutputStream());
            in.close();
            return in.hex();
        }
        catch (IOException e) {
            throw new DigestCreationException(this, file, e);
        }
    }

    public DigestsOutputStream digest(OutputStream out) {
        return new DigestsOutputStream(out, this);
    }

    public DigestsInputStream digest(InputStream out) {
        return new DigestsInputStream(out, this);
    }

    public static class DigestCreationException
    extends RuntimeException {
        public DigestCreationException(Digest digest, File file, Throwable cause) {
            super(String.format("Unable to create %s hash for file '%s'", digest.name(), file.getName()), cause);
        }
    }
}

