/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.archie;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Base64;
import org.tomitribe.archie.Digest;
import org.tomitribe.util.Hex;

public class DigestsInputStream
extends InputStream {
    private final MessageDigest digest;
    private InputStream in;
    private volatile long byteCount;
    private volatile byte[] result;

    public DigestsInputStream(InputStream in, Digest digest) {
        this.in = in;
        this.digest = digest.digest();
    }

    public byte[] digest() {
        if (this.result == null) {
            this.result = this.digest.digest();
        }
        return this.result;
    }

    public String hex() {
        return Hex.toString((byte[])this.digest());
    }

    public String base64() {
        return Base64.getEncoder().encodeToString(this.digest());
    }

    public long getByteCount() {
        return this.byteCount;
    }

    @Override
    public int read() throws IOException {
        int data = this.in.read();
        if (data != -1) {
            ++this.byteCount;
            this.digest.update((byte)data);
        }
        return data;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read > 0) {
            this.byteCount += (long)read;
            this.digest.update(b, off, read);
        }
        return read;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this.in.readAllBytes();
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        return this.in.readNBytes(len);
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.in.readNBytes(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        return this.in.transferTo(out);
    }
}

