/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.archie;

import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import org.tomitribe.archie.Digest;
import org.tomitribe.util.Hex;

public class DigestsOutputStream
extends OutputStream {
    private final MessageDigest messageDigest;
    private OutputStream out;
    private volatile long byteCount;

    public DigestsOutputStream(OutputStream out, Digest digest) {
        this.out = out;
        this.messageDigest = digest.digest();
    }

    @Override
    public void write(int b) throws IOException {
        this.messageDigest.update((byte)b);
        ++this.byteCount;
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.messageDigest.update(b);
        this.byteCount += (long)b.length;
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.messageDigest.update(b, off, len);
        this.byteCount += (long)len;
        this.out.write(b, off, len);
    }

    public byte[] digest() {
        return this.messageDigest.digest();
    }

    public String hex() {
        return Hex.toString((byte[])this.digest());
    }

    public long getByteCount() {
        return this.byteCount;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

