/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.archie;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.tomitribe.util.IO;

public class InlineJar
implements Consumer<ArchiveOutputStream> {
    private final Supplier<byte[]> bytes;

    public InlineJar(Supplier<byte[]> bytes) {
        this.bytes = bytes;
    }

    public InlineJar(byte[] bytes) {
        this(() -> bytes);
    }

    public InlineJar(File file) {
        this(() -> InlineJar.readBytes(file));
    }

    private static byte[] readBytes(File content) {
        try {
            return IO.readBytes((File)content);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void accept(ArchiveOutputStream out) {
        try (JarArchiveInputStream in = new JarArchiveInputStream(IO.read((byte[])this.bytes.get()));){
            JarArchiveEntry entry;
            while ((entry = in.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory()) {
                    JarArchiveEntry dir = new JarArchiveEntry(name);
                    out.putArchiveEntry((ArchiveEntry)dir);
                    out.closeArchiveEntry();
                    continue;
                }
                byte[] bytes = IO.readBytes((InputStream)in);
                JarArchiveEntry file = new JarArchiveEntry(name);
                file.setMethod(entry.getMethod());
                file.setSize((long)bytes.length);
                file.setTime(entry.getTime());
                file.setUnixMode(entry.getUnixMode());
                if (entry.getCreationTime() != null) {
                    file.setCreationTime(entry.getCreationTime());
                }
                if (entry.getLastModifiedTime() != null) {
                    file.setLastModifiedTime(entry.getLastModifiedTime());
                }
                if (entry.getLastAccessTime() != null) {
                    file.setLastAccessTime(entry.getLastAccessTime());
                }
                out.putArchiveEntry((ArchiveEntry)file);
                out.write(bytes);
                out.closeArchiveEntry();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Supplier<byte[]> getBytes() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineJar)) {
            return false;
        }
        InlineJar other = (InlineJar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<byte[]> this$bytes = this.getBytes();
        Supplier<byte[]> other$bytes = other.getBytes();
        return !(this$bytes == null ? other$bytes != null : !this$bytes.equals(other$bytes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineJar;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<byte[]> $bytes = this.getBytes();
        result = result * 59 + ($bytes == null ? 43 : $bytes.hashCode());
        return result;
    }

    public String toString() {
        return "InlineJar(bytes=" + this.getBytes() + ")";
    }
}

