/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.archie;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.tomitribe.util.IO;

public class InsertEntry
implements Consumer<ArchiveOutputStream> {
    private final String name;
    private final Supplier<byte[]> bytes;

    private InsertEntry(String name, Supplier<byte[]> bytes) {
        this.name = name;
        this.bytes = bytes;
    }

    @Override
    public void accept(ArchiveOutputStream archiveOutputStream) {
        try {
            byte[] content = this.bytes.get();
            ArchiveEntry archiveEntry = this.createArchiveEntry(archiveOutputStream, this.name, content);
            archiveOutputStream.putArchiveEntry(archiveEntry);
            archiveOutputStream.write(content);
            archiveOutputStream.closeArchiveEntry();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ArchiveEntry createArchiveEntry(ArchiveOutputStream stream, String entryName, byte[] content) {
        if (stream instanceof TarArchiveOutputStream) {
            TarArchiveEntry entry = new TarArchiveEntry(entryName);
            entry.setSize((long)content.length);
            return entry;
        }
        if (stream instanceof JarArchiveOutputStream) {
            JarArchiveEntry entry = new JarArchiveEntry(entryName);
            entry.setSize((long)content.length);
            return entry;
        }
        if (stream instanceof ZipArchiveOutputStream) {
            ZipArchiveEntry entry = new ZipArchiveEntry(entryName);
            entry.setSize((long)content.length);
            return entry;
        }
        throw new UnsupportedArchiveException(stream);
    }

    private static byte[] readBytes(File content) {
        try {
            return IO.readBytes((File)content);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class UnsupportedArchiveException
    extends RuntimeException {
        public UnsupportedArchiveException(ArchiveOutputStream stream) {
            super(String.format("Unsupported ArchiveOutputStream '%s'", stream.getClass().getName()));
        }
    }

    public static class Builder {
        private String name;
        private Supplier<byte[]> bytes;

        public Builder file(File file) {
            return this.bytes(() -> InsertEntry.readBytes(file));
        }

        public Builder content(String content) {
            return this.bytes(() -> content.getBytes(StandardCharsets.UTF_8));
        }

        Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder bytes(Supplier<byte[]> bytes) {
            this.bytes = bytes;
            return this;
        }

        public InsertEntry build() {
            return new InsertEntry(this.name, this.bytes);
        }

        public String toString() {
            return "InsertEntry.Builder(name=" + this.name + ", bytes=" + this.bytes + ")";
        }
    }
}

