/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.archie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.tomitribe.archie.Transformations;
import org.tomitribe.archie.Transformer;
import org.tomitribe.archie.UnclosableInputStream;
import org.tomitribe.archie.UnclosableOutputStream;
import org.tomitribe.util.IO;

public class TarGzTransformation
implements Transformer,
Function<byte[], byte[]> {
    private final Transformations transformations;

    public TarGzTransformation(Transformations transformations) {
        this.transformations = transformations;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public byte[] apply(byte[] bytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            this.transform(in, out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out.toByteArray();
    }

    @Override
    public void transform(InputStream source, OutputStream destination) throws IOException {
        try (TarArchiveInputStream in = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new UnclosableInputStream(source)));
             TarArchiveOutputStream out = new TarArchiveOutputStream((OutputStream)new GzipCompressorOutputStream((OutputStream)new UnclosableOutputStream(destination)));){
            TarArchiveEntry entry;
            out.setLongFileMode(3);
            this.transformations.beforeArchive((ArchiveOutputStream)out);
            while ((entry = in.getNextTarEntry()) != null) {
                String name = entry.getName();
                this.transformations.beforeEntry(name, (ArchiveOutputStream)out);
                if (entry.isDirectory()) {
                    TarArchiveEntry dir = new TarArchiveEntry(name);
                    out.putArchiveEntry((ArchiveEntry)dir);
                    out.closeArchiveEntry();
                } else if (entry.isLink() || entry.isSymbolicLink()) {
                    out.putArchiveEntry((ArchiveEntry)entry);
                    out.closeArchiveEntry();
                } else {
                    byte[] bytes = this.transformations.apply(name, IO.readBytes((InputStream)in));
                    TarArchiveEntry file = new TarArchiveEntry(name);
                    file.setSize((long)bytes.length);
                    file.setMode(entry.getMode());
                    file.setModTime(entry.getModTime());
                    if (entry.getCreationTime() != null) {
                        file.setCreationTime(entry.getCreationTime());
                    }
                    if (entry.getLastModifiedTime() != null) {
                        file.setLastModifiedTime(entry.getLastModifiedTime());
                    }
                    if (entry.getLastAccessTime() != null) {
                        file.setLastAccessTime(entry.getLastAccessTime());
                    }
                    out.putArchiveEntry((ArchiveEntry)file);
                    out.write(bytes);
                    out.closeArchiveEntry();
                }
                this.transformations.afterEntry(name, (ArchiveOutputStream)out);
            }
            this.transformations.afterArchive((ArchiveOutputStream)out);
        }
    }

    public static class Builder {
        private Transformations.Builder builder = new Transformations.Builder();

        public Builder enhance(String entryName, Function<byte[], byte[]> transformer) {
            this.builder.enhance(entryName, transformer);
            return this;
        }

        public Builder enhance(Predicate<String> entryPredicate, Function<byte[], byte[]> transformer) {
            this.builder.enhance(entryPredicate, transformer);
            return this;
        }

        public Builder prepend(String entryName, String contents) {
            this.builder.prepend(entryName, contents);
            return this;
        }

        public Builder prepend(Predicate<String> entryPredicate, String contents) {
            this.builder.prepend(entryPredicate, contents);
            return this;
        }

        public Builder before(Consumer<ArchiveOutputStream> consumer) {
            this.builder.before(consumer);
            return this;
        }

        public Builder after(Consumer<ArchiveOutputStream> consumer) {
            this.builder.after(consumer);
            return this;
        }

        public Builder beforeEntry(String entryName, Consumer<ArchiveOutputStream> consumer) {
            this.builder.beforeEntry(entryName, consumer);
            return this;
        }

        public Builder beforeEntry(Predicate<String> entryName, Consumer<ArchiveOutputStream> consumer) {
            this.builder.beforeEntry(entryName, consumer);
            return this;
        }

        public Builder afterEntry(String entryName, Consumer<ArchiveOutputStream> consumer) {
            this.builder.afterEntry(entryName, consumer);
            return this;
        }

        public Builder afterEntry(Predicate<String> entryName, Consumer<ArchiveOutputStream> consumer) {
            this.builder.afterEntry(entryName, consumer);
            return this;
        }

        public Builder and(Consumer<Transformations.Builder> consumer) {
            this.builder.and(consumer);
            return this;
        }

        public TarGzTransformation build() {
            return new TarGzTransformation(this.builder.build());
        }
    }
}

