/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.archie;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.ArchiveOutputStream;

public class Transformation
implements Function<byte[], byte[]> {
    private final Predicate<String> condition;
    private final Function<byte[], byte[]> transformation;

    public Transformation(Predicate<String> condition, Function<byte[], byte[]> transformation) {
        this.condition = condition;
        this.transformation = transformation;
    }

    public boolean applies(String name) {
        return this.condition.test(name);
    }

    @Override
    public byte[] apply(byte[] bytes) {
        return this.transformation.apply(bytes);
    }

    public Predicate<String> getCondition() {
        return this.condition;
    }

    public Function<byte[], byte[]> getTransformation() {
        return this.transformation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transformation)) {
            return false;
        }
        Transformation other = (Transformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Predicate<String> this$condition = this.getCondition();
        Predicate<String> other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        Function<byte[], byte[]> this$transformation = this.getTransformation();
        Function<byte[], byte[]> other$transformation = other.getTransformation();
        return !(this$transformation == null ? other$transformation != null : !this$transformation.equals(other$transformation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Transformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Predicate<String> $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        Function<byte[], byte[]> $transformation = this.getTransformation();
        result = result * 59 + ($transformation == null ? 43 : $transformation.hashCode());
        return result;
    }

    public String toString() {
        return "Transformation(condition=" + this.getCondition() + ", transformation=" + this.getTransformation() + ")";
    }

    public static class Action
    implements Consumer<ArchiveOutputStream> {
        private final Predicate<String> condition;
        private final Consumer<ArchiveOutputStream> transformation;

        public boolean applies(String name) {
            return this.condition.test(name);
        }

        @Override
        public void accept(ArchiveOutputStream archiveOutputStream) {
            this.transformation.accept(archiveOutputStream);
        }

        public Action(Predicate<String> condition, Consumer<ArchiveOutputStream> transformation) {
            this.condition = condition;
            this.transformation = transformation;
        }

        public Predicate<String> getCondition() {
            return this.condition;
        }

        public Consumer<ArchiveOutputStream> getTransformation() {
            return this.transformation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action other = (Action)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Predicate<String> this$condition = this.getCondition();
            Predicate<String> other$condition = other.getCondition();
            if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
                return false;
            }
            Consumer<ArchiveOutputStream> this$transformation = this.getTransformation();
            Consumer<ArchiveOutputStream> other$transformation = other.getTransformation();
            return !(this$transformation == null ? other$transformation != null : !this$transformation.equals(other$transformation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Action;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Predicate<String> $condition = this.getCondition();
            result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
            Consumer<ArchiveOutputStream> $transformation = this.getTransformation();
            result = result * 59 + ($transformation == null ? 43 : $transformation.hashCode());
            return result;
        }

        public String toString() {
            return "Transformation.Action(condition=" + this.getCondition() + ", transformation=" + this.getTransformation() + ")";
        }
    }
}

