/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.archie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.security.CodeSigner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.tomitribe.archie.InsertEntry;
import org.tomitribe.archie.JarTransformation;
import org.tomitribe.archie.PassThroughTransformation;
import org.tomitribe.archie.TarGzTransformation;
import org.tomitribe.archie.Transformation;
import org.tomitribe.archie.Transformer;
import org.tomitribe.archie.ZipTransformation;
import org.tomitribe.util.IO;

public class Transformations {
    private final List<Transformation> transformations = new ArrayList<Transformation>();
    private final List<Transformation.Action> before = new ArrayList<Transformation.Action>();
    private final List<Transformation.Action> after = new ArrayList<Transformation.Action>();
    private final List<Transformation.Action> beforeEntry = new ArrayList<Transformation.Action>();
    private final List<Transformation.Action> afterEntry = new ArrayList<Transformation.Action>();
    protected final List<Consumer<Builder>> builderConsumers = new ArrayList<Consumer<Builder>>();
    private final List<Predicate<String>> skipEntry = new ArrayList<Predicate<String>>();
    private final List<Predicate<String>> skipTransformation = new ArrayList<Predicate<String>>();

    public Transformations(List<Transformation> transformations, List<Transformation.Action> before, List<Transformation.Action> after, List<Transformation.Action> beforeEntry, List<Transformation.Action> afterEntry, List<Predicate<String>> skipEntry, List<Predicate<String>> skipTransformation) {
        this.transformations.addAll(transformations);
        this.beforeEntry.addAll(beforeEntry);
        this.afterEntry.addAll(afterEntry);
        this.before.addAll(before);
        this.after.addAll(after);
        this.skipEntry.addAll(skipEntry);
        this.skipTransformation.addAll(skipTransformation);
    }

    public Transformer transformer(File file) {
        String name = file.getName();
        if (name.endsWith(".zip")) {
            return new ZipTransformation(this);
        }
        if (name.endsWith(".tar.gz")) {
            return new TarGzTransformation(this);
        }
        if (name.endsWith(".jar") || name.endsWith(".ear") || name.endsWith(".war") || name.endsWith(".rar")) {
            return new JarTransformation(this);
        }
        if (name.endsWith(".pdf")) {
            return new PassThroughTransformation(this);
        }
        throw new UnsupportedFileTypeException(file);
    }

    public byte[] apply(String entryName, byte[] contents) {
        if (this.skipTransformation(entryName) || this.isSigned(entryName, contents)) {
            return contents;
        }
        for (Transformation transformation : this.transformations) {
            if (!transformation.applies(entryName)) continue;
            contents = transformation.apply(contents);
        }
        return contents;
    }

    public void afterEntry(String entryName, ArchiveOutputStream out) {
        for (Transformation.Action action : this.afterEntry) {
            if (!action.applies(entryName)) continue;
            action.accept(out);
        }
    }

    public void beforeEntry(String entryName, ArchiveOutputStream out) {
        for (Transformation.Action action : this.beforeEntry) {
            if (!action.applies(entryName)) continue;
            action.accept(out);
        }
    }

    public void afterArchive(ArchiveOutputStream out) {
        for (Transformation.Action action : this.after) {
            action.accept(out);
        }
    }

    public void beforeArchive(ArchiveOutputStream out) {
        for (Transformation.Action action : this.before) {
            action.accept(out);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean skip(String name) {
        for (Predicate<String> predicate : this.skipEntry) {
            if (!predicate.test(name)) continue;
            return true;
        }
        return false;
    }

    protected boolean skipTransformation(String name) {
        for (Predicate<String> predicate : this.skipTransformation) {
            if (!predicate.test(name)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isSigned(String name, byte[] content) {
        Objects.requireNonNull(name, "name is required.");
        Objects.requireNonNull(content, "content is required.");
        if (!name.endsWith(".jar")) return false;
        try (JarInputStream jarInputStream = new JarInputStream(new ByteArrayInputStream(content));){
            Manifest manifest = jarInputStream.getManifest();
            if (!this.hasDigestEntry(manifest)) return false;
            if (!this.hasCodeSigners(jarInputStream)) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean hasCodeSigners(JarInputStream jarInputStream) throws IOException {
        JarEntry entry;
        while ((entry = jarInputStream.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            jarInputStream.closeEntry();
            CodeSigner[] codeSigners = entry.getCodeSigners();
            if (codeSigners == null) continue;
            return true;
        }
        return false;
    }

    private boolean hasDigestEntry(Manifest manifest) {
        if (manifest == null) {
            return false;
        }
        for (Map.Entry<String, Attributes> entry : manifest.getEntries().entrySet()) {
            for (Object attrKey : entry.getValue().keySet()) {
                if (!(attrKey instanceof Attributes.Name) || !attrKey.toString().contains("-Digest")) continue;
                return true;
            }
        }
        return false;
    }

    public static class UnsupportedFileTypeException
    extends RuntimeException {
        public UnsupportedFileTypeException(File file) {
            super(String.format("Unsupported file type '%s'. Supported types are zip, tar.gz, jar, war, ear and rar", file.getName()));
        }
    }

    public static class Equals
    implements Predicate<String> {
        private final String expected;

        @Override
        public boolean test(String s) {
            return this.expected.equals(s);
        }

        public Equals(String expected) {
            this.expected = expected;
        }

        public String getExpected() {
            return this.expected;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Equals)) {
                return false;
            }
            Equals other = (Equals)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$expected = this.getExpected();
            String other$expected = other.getExpected();
            return !(this$expected == null ? other$expected != null : !this$expected.equals(other$expected));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Equals;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $expected = this.getExpected();
            result = result * 59 + ($expected == null ? 43 : $expected.hashCode());
            return result;
        }

        public String toString() {
            return "Transformations.Equals(expected=" + this.getExpected() + ")";
        }
    }

    public static class Append
    implements Function<byte[], byte[]> {
        private final String contents;

        @Override
        public byte[] apply(byte[] bytes) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(bytes);
                out.write(this.contents.getBytes());
                return out.toByteArray();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public Append(String contents) {
            this.contents = contents;
        }

        public String getContents() {
            return this.contents;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Append)) {
                return false;
            }
            Append other = (Append)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$contents = this.getContents();
            String other$contents = other.getContents();
            return !(this$contents == null ? other$contents != null : !this$contents.equals(other$contents));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Append;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $contents = this.getContents();
            result = result * 59 + ($contents == null ? 43 : $contents.hashCode());
            return result;
        }

        public String toString() {
            return "Transformations.Append(contents=" + this.getContents() + ")";
        }
    }

    public static class Prepend
    implements Function<byte[], byte[]> {
        private final String contents;

        @Override
        public byte[] apply(byte[] bytes) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(this.contents.getBytes());
                out.write(bytes);
                return out.toByteArray();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public Prepend(String contents) {
            this.contents = contents;
        }

        public String getContents() {
            return this.contents;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prepend)) {
                return false;
            }
            Prepend other = (Prepend)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$contents = this.getContents();
            String other$contents = other.getContents();
            return !(this$contents == null ? other$contents != null : !this$contents.equals(other$contents));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Prepend;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $contents = this.getContents();
            result = result * 59 + ($contents == null ? 43 : $contents.hashCode());
            return result;
        }

        public String toString() {
            return "Transformations.Prepend(contents=" + this.getContents() + ")";
        }
    }

    public static class Builder {
        private final List<Transformation> transformations = new ArrayList<Transformation>();
        private final List<Transformation.Action> before = new ArrayList<Transformation.Action>();
        private final List<Transformation.Action> after = new ArrayList<Transformation.Action>();
        private final List<Transformation.Action> beforeEntry = new ArrayList<Transformation.Action>();
        private final List<Transformation.Action> afterEntry = new ArrayList<Transformation.Action>();
        private final List<Predicate<String>> skipEntry = new ArrayList<Predicate<String>>();
        private final List<Predicate<String>> skipTransformation = new ArrayList<Predicate<String>>();
        protected final List<Consumer<Builder>> builderConsumers = new ArrayList<Consumer<Builder>>();

        public Builder add(String name, Supplier<byte[]> bytes) {
            this.after(InsertEntry.builder().bytes(bytes).name(name).build());
            return this;
        }

        public Builder add(String name, byte[] bytes) {
            return this.add(name, () -> bytes);
        }

        public Builder add(String name, String content) {
            return this.add(name, content::getBytes);
        }

        public Builder add(String name, File content) {
            return this.add(name, () -> Builder.readBytes(content));
        }

        public Builder enhance(String entryName, Function<byte[], byte[]> transformer) {
            this.transformations.add(new Transformation(new Equals(entryName), transformer));
            return this;
        }

        public Builder enhance(Predicate<String> entryPredicate, Function<byte[], byte[]> transformer) {
            this.transformations.add(new Transformation(entryPredicate, transformer));
            return this;
        }

        public Builder prepend(String entryName, String contents) {
            this.transformations.add(new Transformation(new Equals(entryName), new Prepend(contents)));
            return this;
        }

        public Builder prepend(Predicate<String> entryPredicate, String contents) {
            this.transformations.add(new Transformation(entryPredicate, new Prepend(contents)));
            return this;
        }

        public Builder before(Consumer<ArchiveOutputStream> consumer) {
            this.before.add(new Transformation.Action(s -> true, consumer));
            return this;
        }

        public Builder after(Consumer<ArchiveOutputStream> consumer) {
            this.after.add(new Transformation.Action(s -> true, consumer));
            return this;
        }

        public Builder beforeEntry(String entryName, Consumer<ArchiveOutputStream> consumer) {
            return this.beforeEntry(new Equals(entryName), consumer);
        }

        public Builder beforeEntry(Predicate<String> entryName, Consumer<ArchiveOutputStream> consumer) {
            this.beforeEntry.add(new Transformation.Action(entryName, consumer));
            return this;
        }

        public Builder afterEntry(String entryName, Consumer<ArchiveOutputStream> consumer) {
            return this.afterEntry(new Equals(entryName), consumer);
        }

        public Builder afterEntry(Predicate<String> entryName, Consumer<ArchiveOutputStream> consumer) {
            this.afterEntry.add(new Transformation.Action(entryName, consumer));
            return this;
        }

        public Builder skip(Predicate<String> predicate) {
            this.skipEntry.add(predicate);
            return this;
        }

        public Builder skipTransformation(Predicate<String> predicate) {
            this.skipTransformation.add(predicate);
            return this;
        }

        public Builder and(Consumer<Builder> consumer) {
            this.builderConsumers.add(consumer);
            return this;
        }

        private void applyBuilderConsumers() {
            if (this.builderConsumers.size() == 0) {
                return;
            }
            ArrayList<Consumer<Builder>> invoked = new ArrayList<Consumer<Builder>>();
            do {
                ArrayList<Consumer<Builder>> consumers = new ArrayList<Consumer<Builder>>(this.builderConsumers);
                this.builderConsumers.clear();
                for (Consumer<Builder> consumer : consumers) {
                    consumer.accept(this);
                    invoked.add(consumer);
                }
            } while (this.builderConsumers.size() != 0);
            this.builderConsumers.addAll(invoked);
        }

        public Transformations build() {
            this.applyBuilderConsumers();
            return new Transformations(this.transformations, this.before, this.after, this.beforeEntry, this.afterEntry, this.skipEntry, this.skipTransformation);
        }

        public static byte[] readBytes(File content) {
            try {
                return IO.readBytes((File)content);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        public static byte[] readBytes(URL content) {
            try {
                return IO.readBytes((URL)content);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

