/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.archie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.tomitribe.archie.Transformations;
import org.tomitribe.archie.Transformer;
import org.tomitribe.archie.UnclosableInputStream;
import org.tomitribe.archie.UnclosableOutputStream;
import org.tomitribe.util.Files;
import org.tomitribe.util.IO;

public class ZipTransformation
implements Transformer,
Function<byte[], byte[]> {
    private final Transformations transformations;

    public ZipTransformation(Transformations transformations) {
        this.transformations = transformations;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public byte[] apply(byte[] bytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            this.transform(in, out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return out.toByteArray();
    }

    @Override
    public void transform(InputStream source, OutputStream destination) throws IOException {
        try (ZipArchiveInputStream in = new ZipArchiveInputStream((InputStream)new UnclosableInputStream(source));
             ZipArchiveOutputStream out = new ZipArchiveOutputStream((OutputStream)new UnclosableOutputStream(destination));){
            ZipArchiveEntry entry;
            this.transformations.beforeArchive((ArchiveOutputStream)out);
            File tmpdir = Files.tmpdir();
            while ((entry = in.getNextZipEntry()) != null) {
                String name = entry.getName();
                this.transformations.beforeEntry(name, (ArchiveOutputStream)out);
                if (entry.isDirectory()) {
                    ZipArchiveEntry dir = new ZipArchiveEntry(name);
                    out.putArchiveEntry((ArchiveEntry)dir);
                    out.closeArchiveEntry();
                } else {
                    byte[] bytes = this.transformations.apply(name, IO.readBytes((InputStream)in));
                    try {
                        ZipArchiveEntry file = new ZipArchiveEntry(name);
                        file.setMethod(entry.getMethod());
                        file.setSize((long)bytes.length);
                        file.setTime(entry.getTime());
                        if (entry.getCreationTime() != null) {
                            file.setCreationTime(entry.getCreationTime());
                        }
                        if (entry.getLastModifiedTime() != null) {
                            file.setLastModifiedTime(entry.getLastModifiedTime());
                        }
                        if (entry.getLastAccessTime() != null) {
                            file.setLastAccessTime(entry.getLastAccessTime());
                        }
                        CRC32 crc32 = new CRC32();
                        crc32.update(bytes);
                        file.setCrc(crc32.getValue());
                        file.setExtra(new byte[0]);
                        out.putArchiveEntry((ArchiveEntry)file);
                        out.write(bytes);
                        out.closeArchiveEntry();
                    }
                    catch (IOException e) {
                        throw new IOException("Failed to create entry: " + name, e);
                    }
                }
                this.transformations.afterEntry(name, (ArchiveOutputStream)out);
            }
            this.transformations.afterArchive((ArchiveOutputStream)out);
        }
    }

    public static class Builder {
        private Transformations.Builder builder = new Transformations.Builder();

        public Builder enhance(String entryName, Function<byte[], byte[]> transformer) {
            this.builder.enhance(entryName, transformer);
            return this;
        }

        public Builder enhance(Predicate<String> entryPredicate, Function<byte[], byte[]> transformer) {
            this.builder.enhance(entryPredicate, transformer);
            return this;
        }

        public Builder prepend(String entryName, String contents) {
            this.builder.prepend(entryName, contents);
            return this;
        }

        public Builder prepend(Predicate<String> entryPredicate, String contents) {
            this.builder.prepend(entryPredicate, contents);
            return this;
        }

        public Builder before(Consumer<ArchiveOutputStream> consumer) {
            this.builder.before(consumer);
            return this;
        }

        public Builder after(Consumer<ArchiveOutputStream> consumer) {
            this.builder.after(consumer);
            return this;
        }

        public Builder beforeEntry(String entryName, Consumer<ArchiveOutputStream> consumer) {
            this.builder.beforeEntry(entryName, consumer);
            return this;
        }

        public Builder beforeEntry(Predicate<String> entryName, Consumer<ArchiveOutputStream> consumer) {
            this.builder.beforeEntry(entryName, consumer);
            return this;
        }

        public Builder afterEntry(String entryName, Consumer<ArchiveOutputStream> consumer) {
            this.builder.afterEntry(entryName, consumer);
            return this;
        }

        public Builder afterEntry(Predicate<String> entryName, Consumer<ArchiveOutputStream> consumer) {
            this.builder.afterEntry(entryName, consumer);
            return this;
        }

        public Builder and(Consumer<Transformations.Builder> consumer) {
            this.builder.and(consumer);
            return this;
        }

        public ZipTransformation build() {
            return new ZipTransformation(this.builder.build());
        }
    }
}

