/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.archie.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.tomitribe.archie.util.Zips;
import org.tomitribe.util.Files;
import org.tomitribe.util.IO;
import org.tomitribe.util.Longs;
import org.tomitribe.util.PrintString;
import org.tomitribe.util.hash.XxHash64;

public class TarGzs {
    private TarGzs() {
    }

    public static void untargz(File zipFile, File destination) throws IOException {
        TarGzs.untargz(zipFile, destination, false);
    }

    public static void untargz(File zipFile, File destination, boolean noparent) throws IOException {
        TarGzs.untargz(zipFile, destination, noparent, (File pathname) -> true);
    }

    public static void untargz(File zipFile, File destination, boolean noparent, FileFilter fileFilter) throws IOException {
        Files.file((File)zipFile);
        Files.readable((File)zipFile);
        try (InputStream read = IO.read((File)zipFile);){
            TarGzs.untargz(read, destination, noparent, fileFilter);
        }
    }

    public static void untargz(InputStream read, File destination, boolean noparent, FileFilter fileFilter) throws IOException {
        Objects.requireNonNull(fileFilter, "'fileFilter' is required.");
        Files.dir((File)destination);
        Files.writable((File)destination);
        try {
            TarArchiveEntry entry;
            GzipCompressorInputStream gzipIn = new GzipCompressorInputStream(read);
            TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)gzipIn);
            while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                File file;
                String path = entry.getName();
                if (noparent) {
                    path = path.replaceFirst("^[^/]+/", "");
                }
                if (!fileFilter.accept(file = new File(destination, path))) continue;
                if (entry.isDirectory()) {
                    Files.mkdirs((File)file, (String[])new String[0]);
                    continue;
                }
                Files.mkdirs((File)file.getParentFile(), (String[])new String[0]);
                IO.copy((InputStream)tarIn, (File)file);
                long lastModified = entry.getLastModifiedDate().getTime();
                if (lastModified > 0L) {
                    file.setLastModified(lastModified);
                }
                if (33261 == entry.getMode()) {
                    file.setExecutable(true);
                }
                if (493 != entry.getMode()) continue;
                file.setExecutable(true);
            }
            tarIn.close();
        }
        catch (IOException var9) {
            throw new IOException("Unable to unzip " + read, var9);
        }
    }

    public static String list(File zip) {
        String string;
        block8: {
            InputStream in = IO.read((File)zip);
            try {
                string = TarGzs.list(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return string;
    }

    public static String list(InputStream read) {
        PrintString out = new PrintString();
        TarGzs.list(read, "", (PrintStream)out);
        return out.toString();
    }

    public static void list(InputStream read, String parent, PrintStream out) {
        try (TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(read));){
            TarArchiveEntry entry;
            while ((entry = (TarArchiveEntry)tarIn.getNextEntry()) != null) {
                String path = entry.getName();
                if (entry.isDirectory()) {
                    out.printf("%s%s%n", parent, path);
                    continue;
                }
                byte[] bytes = IO.readBytes((InputStream)tarIn);
                if (path.endsWith(".jar") || path.endsWith(".war") || path.endsWith(".rar") || path.endsWith(".ear") || path.endsWith(".zip")) {
                    out.printf("%s%s%n", parent, path);
                    Zips.list(IO.read((byte[])bytes), parent + path + " > ", out);
                    continue;
                }
                if (path.endsWith(".tar.gz")) {
                    out.printf("%s%s%n", parent, path);
                    TarGzs.list(IO.read((byte[])bytes), parent + path + " > ", out);
                    continue;
                }
                long hash = XxHash64.hash((InputStream)IO.read((byte[])bytes));
                String hex = Longs.toHex((long)hash);
                out.printf("%s%s  %s%n", parent, path, hex);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to untar " + read, e);
        }
    }
}

