/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.archie.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.tomitribe.archie.util.TarGzs;
import org.tomitribe.util.Files;
import org.tomitribe.util.IO;
import org.tomitribe.util.Longs;
import org.tomitribe.util.PrintString;
import org.tomitribe.util.hash.XxHash64;

public class Zips {
    private Zips() {
    }

    public static void unzip(File zipFile, File destination) throws IOException {
        Zips.unzip(zipFile, destination, false);
    }

    public static void unzip(File zipFile, File destination, boolean noparent) throws IOException {
        Zips.unzip(zipFile, destination, noparent, (File pathname) -> true);
    }

    public static void unzip(File zipFile, File destination, boolean noparent, FileFilter fileFilter) throws IOException {
        Files.file((File)zipFile);
        Files.readable((File)zipFile);
        try (InputStream read = IO.read((File)zipFile);){
            Zips.unzip(read, destination, noparent, fileFilter);
        }
    }

    public static void unzip(InputStream read, File destination, boolean noparent, FileFilter fileFilter) throws IOException {
        Objects.requireNonNull(fileFilter, "'fileFilter' is required.");
        Files.dir((File)destination);
        Files.writable((File)destination);
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        try {
            ZipEntry entry;
            ZipInputStream e = new ZipInputStream(read);
            while ((entry = e.getNextEntry()) != null) {
                entries.add(entry);
                try {
                    File file;
                    String path = entry.getName();
                    if (noparent) {
                        path = path.replaceFirst("^[^/]+/", "");
                    }
                    if (!fileFilter.accept(file = new File(destination, path))) continue;
                    if (entry.isDirectory()) {
                        Files.mkdirs((File)file, (String[])new String[0]);
                        continue;
                    }
                    Files.mkdirs((File)file.getParentFile(), (String[])new String[0]);
                    IO.copy((InputStream)e, (File)file);
                    long lastModified = entry.getTime();
                    if (lastModified <= 0L) continue;
                    file.setLastModified(lastModified);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Entry: " + entry.getName(), ex);
                }
            }
            e.close();
        }
        catch (IOException var9) {
            throw new IOException("Unable to unzip " + read, var9);
        }
    }

    public static String list(File zip) {
        String string;
        block8: {
            InputStream in = IO.read((File)zip);
            try {
                string = Zips.list(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return string;
    }

    public static String list(InputStream read) {
        PrintString out = new PrintString();
        Zips.list(read, "", (PrintStream)out);
        return out.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void list(InputStream read, String parent, PrintStream out) {
        try {
            ZipEntry entry;
            ZipInputStream e = new ZipInputStream(read);
            while ((entry = e.getNextEntry()) != null) {
                try {
                    String path = entry.getName();
                    if (entry.isDirectory()) {
                        out.printf("%s%s%n", parent, path);
                        continue;
                    }
                    byte[] bytes = IO.readBytes((InputStream)e);
                    if (path.endsWith(".jar") || path.endsWith(".war") || path.endsWith(".rar") || path.endsWith(".ear") || path.endsWith(".zip")) {
                        out.printf("%s%s%n", parent, path);
                        Zips.list(IO.read((byte[])bytes), parent + path + " > ", out);
                        continue;
                    }
                    if (path.endsWith(".tar.gz")) {
                        out.printf("%s%s%n", parent, path);
                        TarGzs.list(IO.read((byte[])bytes), parent + path + " > ", out);
                        continue;
                    }
                    long hash = XxHash64.hash((InputStream)IO.read((byte[])bytes));
                    String hex = Longs.toHex((long)hash);
                    out.printf("%s%s  %s%n", parent, path, hex);
                }
                catch (IOException ex) {
                    throw new RuntimeException("Entry: " + entry.getName(), ex);
                    return;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to unzip " + read, e);
        }
    }
}

