/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.beryllium.mocks;

import com.xebialabs.restito.builder.stub.StubHttp;
import com.xebialabs.restito.semantics.Action;
import com.xebialabs.restito.semantics.Condition;
import com.xebialabs.restito.semantics.ConditionWithApplicables;
import com.xebialabs.restito.semantics.Stub;
import com.xebialabs.restito.server.StubServer;
import cucumber.api.DataTable;
import cucumber.api.java.After;
import cucumber.api.java.Before;
import cucumber.api.java.en.Given;
import java.beans.ConstructorProperties;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.grizzly.http.util.HttpStatus;

public class CallsSteps {
    private StubServer server;
    private StubHttp stubHttp;

    @Before
    public void setUp() {
        this.server = new StubServer(9090, new Stub[0]).run();
        this.stubHttp = StubHttp.whenHttp((StubServer)this.server);
    }

    @After
    public void tearDown() {
        this.server.stop();
    }

    @Given(value="^The call to external service should be:$")
    public void theCallToExternalServiceShouldBe(DataTable data) throws Throwable {
        List calls = data.asList(Call.class);
        for (Call call : calls) {
            this.stubHttp.match(new Condition[]{call.getHttpMethod(), call.buildQueryParams()}).then(new Action[]{Action.status((HttpStatus)HttpStatus.getHttpStatus((int)call.getStatusCode())), Action.resourceContent((URL)Thread.currentThread().getContextClassLoader().getResource("fixtures/" + call.getFilename()))});
        }
    }

    private static final class Call {
        private final String method;
        private final String url;
        private final int statusCode;
        private final String filename;

        ConditionWithApplicables getHttpMethod() {
            switch (this.getMethod().toUpperCase()) {
                case "POST": {
                    return Condition.post((String)this.buildUrl());
                }
                case "PUT": {
                    return Condition.put((String)this.buildUrl());
                }
                case "DELETE": {
                    return Condition.delete((String)this.buildUrl());
                }
                case "GET": {
                    return Condition.get((String)this.buildUrl());
                }
            }
            return Condition.get((String)this.buildUrl());
        }

        String buildUrl() {
            return this.getUrl().contains("?") ? this.getUrl().split("\\?")[0] : this.getUrl();
        }

        Condition buildQueryParams() {
            String queryParamsStr = this.getUrl().contains("?") ? this.getUrl().split("\\?")[1] : null;
            String[] kvs = queryParamsStr != null ? queryParamsStr.split("\\&") : new String[]{};
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            for (String kv : kvs) {
                String[] sp = kv.split("\\=");
                conditions.add(Condition.parameter((String)sp[0], (String[])new String[]{sp[1]}));
            }
            return Condition.composite((Condition[])conditions.toArray(new Condition[conditions.size()]));
        }

        @ConstructorProperties(value={"method", "url", "statusCode", "filename"})
        public Call(String method, String url, int statusCode, String filename) {
            this.method = method;
            this.url = url;
            this.statusCode = statusCode;
            this.filename = filename;
        }

        public String getMethod() {
            return this.method;
        }

        public String getUrl() {
            return this.url;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Call)) {
                return false;
            }
            Call other = (Call)o;
            String this$method = this.getMethod();
            String other$method = other.getMethod();
            if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            if (this.getStatusCode() != other.getStatusCode()) {
                return false;
            }
            String this$filename = this.getFilename();
            String other$filename = other.getFilename();
            return !(this$filename == null ? other$filename != null : !this$filename.equals(other$filename));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : $method.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            result = result * 59 + this.getStatusCode();
            String $filename = this.getFilename();
            result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
            return result;
        }

        public String toString() {
            return "CallsSteps.Call(method=" + this.getMethod() + ", url=" + this.getUrl() + ", statusCode=" + this.getStatusCode() + ", filename=" + this.getFilename() + ")";
        }
    }
}

