/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.beryllium.redis;

import com.google.common.truth.Truth;
import cucumber.api.DataTable;
import cucumber.api.java.en.Given;
import cucumber.api.java.en.Then;
import java.util.List;
import org.tomitribe.beryllium.Utility;
import org.tomitribe.beryllium.redis.RedisUtil;
import redis.clients.jedis.Jedis;

public class RedisListSteps {
    @Given(value="^I have the redis list \"([^\"]*)\"(?: in the db (\\d+))? with values \"([^\"]*)\"$")
    public void iHaveTheRedisListInTheDbWithValues(String list, Integer db, String values) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        jedis.lpush(list, values.split(","));
        jedis.close();
    }

    @Given(value="^I have the redis list \"([^\"]*)\"(?: in the db (\\d+))? with values in file \"([^\"]*)\"$")
    public void iHaveTheRedisListInTheDbWithValuesWithFiles(String list, Integer db, String filename) throws Throwable {
        this.iHaveTheRedisListInTheDbWithValues(list, db, Utility.fileContent(filename.trim()));
    }

    @Given(value="^I have the redis list \"([^\"]*)\"(?: in the db (\\d+))? with values:$")
    public void iHaveTheRedisListInTheDbWithValues(String list, Integer db, DataTable dataTable) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        List table = dataTable.asList(String.class);
        jedis.lpush(list, table.toArray(new String[table.size()]));
        jedis.close();
    }

    @Given(value="^I have the redis list \"([^\"]*)\"(?: in the db (\\d+))? with values \"([^\"]*)\" with ttl (\\d+) seconds$")
    public void iHaveTheRedisListInTheDbWithValuesWithTtlSeconds(String list, Integer db, String values, int seconds) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        jedis.lpush(list, values.split(","));
        jedis.expire(list, seconds);
        jedis.close();
    }

    @Then(value="^the redis list \"([^\"]*)\"(?: in the db (\\d+))? should be \"([^\"]*)\"$")
    public void theRedisListInTheDbShouldBe(String list, Integer db, String values) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        for (String value : values.split(",")) {
            Truth.assertThat((String)values).contains((CharSequence)jedis.lpop(list));
        }
        jedis.close();
    }

    @Then(value="^the redis list \"([^\"]*)\"(?: in the db (\\d+))? should be:$")
    public void theRedisListInTheDbShouldBe(String list, Integer db, DataTable dataTable) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        List table = dataTable.asList(String.class);
        for (String value : table) {
            Truth.assertThat((Iterable)table).contains((Object)jedis.lpop(list));
        }
        jedis.close();
    }

    @Then(value="^the redis list \"([^\"]*)\"(?: in the db (\\d+))? should exists$")
    public void theRedisListInTheDbShouldExists(String list, Integer db) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        Truth.assertThat((Boolean)jedis.exists(list)).isTrue();
        jedis.close();
    }

    @Then(value="^the redis lists \"([^\"]*)\"(?: in the db (\\d+))? should exists$")
    public void theRedisListsInTheDbShouldExists(String list, Integer db) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        for (String key : list.split(",")) {
            Truth.assertThat((Boolean)jedis.exists(key)).isTrue();
        }
        jedis.close();
    }

    @Then(value="^the redis lists(?: in the db (\\d+))? should exists:$")
    public void theRedisListsInTheDbShouldExists(Integer db, DataTable dataTable) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        for (String key : dataTable.asList(String.class)) {
            Truth.assertThat((Boolean)jedis.exists(key)).isTrue();
        }
        jedis.close();
    }

    @Then(value="^the redis list \"([^\"]*)\"(?: in the db (\\d+))? should not exists after (\\d+) seconds$")
    public void theRedisListShouldNotExistsAfterSeconds(String list, Integer db, int seconds) throws Throwable {
        Thread.sleep(seconds * 1000);
        this.theRedisListsShouldNotExists(list, db);
    }

    @Then(value="^the redis list \"([^\"]*)\"(?: in the db (\\d+))? should not exists$")
    public void theRedisListShouldNotExists(String list, Integer db) throws Throwable {
        this.theRedisListShouldNotExistsAfterSeconds(list, db, 1);
    }

    @Then(value="^the redis lists \"([^\"]*)\"(?: in the db (\\d+))? should not exists$")
    public void theRedisListsShouldNotExists(String list, Integer db) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        for (String key : list.split(",")) {
            Truth.assertThat((Boolean)jedis.exists(key)).isFalse();
        }
        jedis.close();
    }

    @Then(value="^the redis list \"([^\"]*)\"(?: in the db (\\d+))? should be file \"([^\"]*)\"$")
    public void theRedisListShouldBeFile(String list, Integer db, String filename) throws Throwable {
        Jedis jedis = RedisUtil.getJedis(db);
        Object[] values = Utility.fileContent(filename).split("\n");
        Truth.assertThat((Object[])values).asList().contains((Object)jedis.lpop(list));
        jedis.close();
    }
}

