/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.beryllium.rest;

import com.google.common.truth.Truth;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.RequestSpecification;
import cucumber.api.DataTable;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import net.javacrumbs.jsonunit.core.Option;
import net.javacrumbs.jsonunit.fluent.JsonFluentAssert;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.tomitribe.beryllium.Utility;

public class RestSteps {
    private Response response;
    private String responseValue;
    @ArquillianResource
    private URL arquillianUrl;

    private RequestSpecification create() {
        return RestAssured.given().baseUri(this.arquillianUrl.toString());
    }

    @When(value="^I make a (GET|HEAD) call to \"(.*?)\" endpoint$")
    public final void iMakeAGetHeadCallToEndpoint(String method, String endpointUrl) throws Throwable {
        this.execute(this.create(), method, endpointUrl);
    }

    private void execute(RequestSpecification spec, String method, String endpointUrl) throws Exception {
        this.response = "GET".equals(method) ? (Response)spec.get(endpointUrl, new Object[0]) : (Response)spec.head(endpointUrl, new Object[0]);
        this.responseValue = this.response.asString();
    }

    @When(value="^I make a (POST|PUT) call to \"(.*?)\" endpoint with post body:$")
    public final void iMakeAPostPutCallToEndpointWithPostBody(String method, String endpointUrl, String postBody) throws Throwable {
        this.response = method.equals("POST") ? (Response)this.create().post(endpointUrl, new Object[0]) : (Response)this.create().put(endpointUrl, new Object[0]);
        this.responseValue = this.response.asString();
    }

    @When(value="^I make a (POST|PUT) call to \"(.*?)\" endpoint with post body in file \"(.*?)\"$")
    public final void iMakeAPostPutCallToEndpointWithPostBodyInFile(String method, String endpointUrl, String postBodyFilePath) throws Throwable {
        this.iMakeAPostPutCallToEndpointWithPostBody(method, endpointUrl, Utility.fileContent(postBodyFilePath));
    }

    @When(value="^I make a DELETE call to \"(.*?)\" endpoint$")
    public final void iMakeADeleteCallToEndpoint(String endpointUrl) throws Throwable {
        this.response = (Response)this.create().delete(endpointUrl, new Object[0]);
        this.responseValue = this.response.asString();
    }

    @When(value="^I make a (GET|HEAD) call to \"(.*?)\" endpoint with headers:$")
    public void iMakeAGetHeadCallToEndpointWithHeaders(String method, String endpointUrl, DataTable headers) throws Throwable {
        RequestSpecification spec = this.create().headers(headers.asMap(String.class, String.class));
        this.execute(spec, method, endpointUrl);
    }

    @When(value="^I make a (GET|HEAD) call to \"(.*?)\" endpoint with query params:$")
    public void iMakeAGetHeadCallToEndpointWithQueryParams(String method, String endpointUrl, DataTable params) throws Throwable {
        RequestSpecification spec = this.create().params(params.asMap(String.class, String.class));
        this.execute(spec, method, endpointUrl);
    }

    @When(value="^I make a (POST|PUT) call to \"(.*?)\" endpoint with post body in file \"(.*?)\" and headers:$")
    public void iMakeAPostPutCallToEndpointWithPostBodyInFileAndHeaders(String method, String endpointUrl, String postBodyFilePath, DataTable headers) throws IOException, URISyntaxException {
        RequestSpecification spec = this.create().headers(headers.asMap(String.class, String.class)).body(Utility.fileContent(postBodyFilePath));
        this.response = method.equals("POST") ? (Response)spec.post(endpointUrl, new Object[0]) : (Response)spec.put(endpointUrl, new Object[0]);
        this.responseValue = this.response.asString();
    }

    @Then(value="^response status code should be (\\d+)$")
    public final void responseStatusCodeShouldBe(int statusCode) throws Throwable {
        Truth.assertThat((Integer)this.response.getStatusCode()).isEqualTo((Object)statusCode);
    }

    @Then(value="^response content type should be \"(.*?)\"$")
    public final void responseContentTypeShouldBe(String contentType) throws Throwable {
        Truth.assertThat((String)contentType).isEqualTo((Object)this.response.contentType());
    }

    @Then(value="^response should be json in file \"(.*?)\"$")
    public final void responseShouldBeJsonResponseBody(String contentFilePath) throws Throwable {
        String content = Utility.fileContent(contentFilePath);
        this.responseShouldBeJson(content);
    }

    @Then(value="^response should be json in file \"(.*?)\" ignoring array order$")
    public final void responseShouldBeJsonIgnoringArrayOdersResponseBody(String contentFilePath) throws Throwable {
        String content = Utility.fileContent(contentFilePath);
        this.responseShouldBeJsonIgnoringArrayOrder(content);
    }

    @Then(value="^response should be json:$")
    public final void responseShouldBeJson(String jsonResponseString) throws Throwable {
        JsonFluentAssert.assertThatJson((Object)this.responseValue).ignoring("${json-unit.ignore}").isEqualTo((Object)jsonResponseString);
    }

    @Then(value="^response should be json ignoring array order:$")
    public final void responseShouldBeJsonIgnoringArrayOrder(String jsonResponseString) throws Throwable {
        JsonFluentAssert.assertThatJson((Object)this.responseValue).ignoring("${json-unit.ignore}").when(Option.IGNORING_ARRAY_ORDER, new Option[0]).isEqualTo((Object)jsonResponseString);
    }

    @Then(value="^response should be empty$")
    public final void responseShouldBeEmpty() throws Throwable {
        Truth.assertThat((String)this.responseValue).isEmpty();
    }

    @Then(value="^response should be:$")
    public final void responseShouldBe(String contentFile) throws Throwable {
        Truth.assertThat((String)this.responseValue).isEqualTo((Object)contentFile);
    }

    @Then(value="^response should be file \"(.*?)\"$")
    public final void responseShouldBeFile(String contentFilePath) throws Throwable {
        this.responseShouldBe(Utility.fileContent(contentFilePath));
    }

    @Then(value="^response header \"(.*?)\" should be \"(.*?)\"$")
    public final void responseHeaderShouldBe(String responseHeaderName, String headerValue) throws Throwable {
        Truth.assertThat((String)this.response.getHeader(responseHeaderName)).isEqualTo((Object)headerValue);
    }

    @Then(value="^response json path list \"(.*?)\" should be:$")
    public void responseJsonPathListShouldBe(String jsonPath, DataTable list) throws Throwable {
        List responseList = (List)JsonPath.read((String)this.responseValue, (String)jsonPath, (Predicate[])new Predicate[0]);
        Truth.assertThat((Iterable)responseList).isEqualTo((Object)list.asList(String.class));
    }

    @Then(value="^response json path element \"(.*?)\" should be \"(.*?)\"$")
    public void responseJsonPathElementShouldBe(String jsonPath, String value) throws Throwable {
        Object responseValue = JsonPath.read((String)this.responseValue, (String)jsonPath, (Predicate[])new Predicate[0]);
        Truth.assertThat((String)String.valueOf(responseValue)).isEqualTo((Object)value);
    }

    @Then(value="^response json path list \"(.*?)\" should be of length (\\d+)$")
    public void responseJsonPathListShouldBeOfLength(String jsonPath, int length) {
        List responseList = (List)JsonPath.read((String)this.responseValue, (String)jsonPath, (Predicate[])new Predicate[0]);
        Truth.assertThat((Integer)responseList.size()).isEqualTo((Object)length);
    }

    @Then(value="^response json path list \"(.*?)\" should be at least of length (\\d+)$")
    public void responseJsonPathListShouldBeAtLeastOfLength(String jsonPath, int length) {
        List responseList = (List)JsonPath.read((String)this.responseValue, (String)jsonPath, (Predicate[])new Predicate[0]);
        Truth.assertThat((Integer)responseList.size()).isAtLeast((Comparable)Integer.valueOf(length));
    }
}

