/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.booh;

import geb.Browser;
import geb.Configuration;
import geb.waiting.Wait;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.loader.Zips;
import org.apache.openejb.loader.provisining.ProvisioningResolver;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriverService;
import org.openqa.selenium.remote.DesiredCapabilities;

public class Booh {
    private Booh() {
    }

    public static Browser drive(Map config, Closure closure) {
        Configuration conf = new Configuration((Map)new HashMap(config){
            {
                this.putIfAbsent("driver", new Closure<WebDriver>(null){

                    public WebDriver call() {
                        return Booh.newDriver();
                    }
                });
                this.putIfAbsent("reportsDir", System.getProperty("booh.report.dir", "target/booh"));
            }
        });
        if (conf.getDefaultWaitTimeout().equals(Wait.DEFAULT_TIMEOUT)) {
            conf.setDefaultWaitTimeout(Double.valueOf(15.0));
        }
        return Browser.drive((Configuration)conf, (Closure)closure);
    }

    public static Browser drive(Closure closure) {
        return Booh.drive(new HashMap(), closure);
    }

    public static WebDriver newDriver() {
        File phantomJs = new File(System.getProperty("java.io.tmpdir", "temp"), "phantomjs-" + System.nanoTime());
        Files.deleteOnExit((File)phantomJs);
        phantomJs.mkdirs();
        File exec = new File(phantomJs, "bin/phantomjs" + (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win") ? ".exe" : ""));
        if (!exec.isFile()) {
            File tmp = new File(phantomJs.getParentFile(), "phantom.jar");
            try {
                try (InputStream stream = ((ProvisioningResolver)SystemInstance.get().getComponent(ProvisioningResolver.class)).resolveStream("mvn:org.jboss.arquillian.extension:arquillian-phantom-binary:2.1.1:jar:" + Booh.findSuffix());
                     FileOutputStream out = new FileOutputStream(tmp);){
                    IO.copy((InputStream)stream, (OutputStream)out);
                }
                Zips.unzip((File)tmp, (File)phantomJs);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            exec.setExecutable(true);
        }
        PhantomJSDriverService service = new PhantomJSDriverService.Builder().usingPhantomJSExecutable(exec).usingAnyFreePort().build();
        PhantomJSDriver driver = new PhantomJSDriver(service, (Capabilities)DesiredCapabilities.chrome());
        Runtime.getRuntime().addShutdownHook(new Thread(() -> ((PhantomJSDriver)driver).close()));
        return driver;
    }

    private static String findSuffix() {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        if (os.contains("mac")) {
            return "macosx";
        }
        if (os.contains("win")) {
            return "windows";
        }
        if (os.contains("linux")) {
            return "linux-64";
        }
        throw new IllegalArgumentException("Unsupported platform (or force os.name system property to contain mac, win or linux): " + os);
    }

    static {
        if (!SystemInstance.isInitialized()) {
            SystemInstance.get().setComponent(ProvisioningResolver.class, (Object)new ProvisioningResolver());
        }
    }
}

