/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.tomitribe.churchkey.InvalidPrivateKeySpecException;
import org.tomitribe.churchkey.InvalidPublicKeySpecException;
import org.tomitribe.churchkey.UnsupportedAlgorithmException;
import org.tomitribe.churchkey.jwk.JwkParser;
import org.tomitribe.churchkey.pem.PemParser;
import org.tomitribe.churchkey.ssh.OpenSSHParser;
import org.tomitribe.churchkey.ssh.SSH2Parser;

public class Key {
    private final java.security.Key key;
    private final Type type;
    private final Algorithm algorithm;
    private final Format format;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public Key(java.security.Key key, Type type, Algorithm algorithm, Format format) {
        this(key, type, algorithm, format, new HashMap<String, String>());
    }

    public Key(java.security.Key key, Type type, Algorithm algorithm, Format format, Map<String, String> attributes) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(format);
        Objects.requireNonNull(attributes);
        this.key = key;
        this.type = type;
        this.algorithm = algorithm;
        this.format = format;
        this.attributes.putAll(attributes);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public java.security.Key getKey() {
        return this.key;
    }

    public Type getType() {
        return this.type;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Format getFormat() {
        return this.format;
    }

    public byte[] encode(Format format) {
        return format.encode(this);
    }

    public static class Factory {
        private final KeyFactory keyFactory;

        public Factory(KeyFactory keyFactory) {
            this.keyFactory = keyFactory;
        }

        public PublicKey generatePublic(KeySpec keySpec) {
            try {
                return this.keyFactory.generatePublic(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidPrivateKeySpecException(keySpec, e);
            }
        }

        public PrivateKey generatePrivate(KeySpec keySpec) {
            try {
                return this.keyFactory.generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidPublicKeySpecException(keySpec, e);
            }
        }
    }

    public static enum Format {
        JWK(new JwkParser()),
        OPENSSH(new OpenSSHParser()),
        SSH2(new SSH2Parser()),
        PEM(new PemParser());

        private final Parser parser;

        private Format(Parser parser) {
            this.parser = parser;
        }

        public byte[] encode(Key key) {
            return this.parser.encode(key);
        }

        public Key decode(byte[] bytes) {
            return this.parser.decode(bytes);
        }

        public static interface Parser {
            public Key decode(byte[] var1);

            public byte[] encode(Key var1);
        }
    }

    public static enum Algorithm {
        RSA,
        DSA,
        EC,
        OCT;


        public Factory getKeyFactory() {
            if (this == OCT) {
                throw new UnsupportedOperationException();
            }
            try {
                return new Factory(KeyFactory.getInstance(this.name()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedAlgorithmException(this, (Throwable)e);
            }
        }
    }

    public static enum Type {
        PUBLIC,
        PRIVATE,
        SECRET;

    }
}

