/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey;

import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;
import org.tomitribe.churchkey.Key;

public class Keys {
    private Keys() {
    }

    public static Key decode(byte[] bytes) {
        for (Key.Format format : Key.Format.values()) {
            Key key = format.decode(bytes);
            if (key == null) continue;
            return key;
        }
        throw new IllegalArgumentException("Cannot decode key: " + new String(bytes));
    }

    public static byte[] encode(Key key) {
        return Keys.encode(key, key.getFormat());
    }

    public static byte[] encode(Key key, Key.Format format) {
        return format.encode(key);
    }

    public static Key of(java.security.Key key) {
        Objects.requireNonNull(key);
        if (key instanceof DSAPrivateKey) {
            return Keys.of((DSAPrivateKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return Keys.of((DSAPublicKey)key);
        }
        if (key instanceof ECPrivateKey) {
            return Keys.of((ECPrivateKey)key);
        }
        if (key instanceof ECPublicKey) {
            return Keys.of((ECPublicKey)key);
        }
        if (key instanceof RSAPrivateCrtKey) {
            return Keys.of((RSAPrivateCrtKey)key);
        }
        if (key instanceof RSAPrivateKey) {
            return Keys.of((RSAPrivateKey)key);
        }
        if (key instanceof RSAPublicKey) {
            return Keys.of((RSAPublicKey)key);
        }
        throw new UnsupportedOperationException("Unsupported key type: " + key.getClass().getName());
    }

    public static Key of(DSAPrivateKey key) {
        return new Key(key, Key.Type.PRIVATE, Key.Algorithm.DSA, Key.Format.PEM);
    }

    public static Key of(DSAPublicKey key) {
        return new Key(key, Key.Type.PUBLIC, Key.Algorithm.DSA, Key.Format.PEM);
    }

    public static Key of(ECPrivateKey key) {
        return new Key(key, Key.Type.PRIVATE, Key.Algorithm.EC, Key.Format.PEM);
    }

    public static Key of(ECPublicKey key) {
        return new Key(key, Key.Type.PUBLIC, Key.Algorithm.EC, Key.Format.PEM);
    }

    public static Key of(RSAPrivateCrtKey key) {
        return new Key(key, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.PEM);
    }

    public static Key of(RSAPrivateKey key) {
        return new Key(key, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.PEM);
    }

    public static Key of(RSAPublicKey key) {
        return new Key(key, Key.Type.PUBLIC, Key.Algorithm.RSA, Key.Format.PEM);
    }
}

