/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.asn1;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.util.Arrays;
import org.tomitribe.churchkey.asn1.Asn1Object;
import org.tomitribe.churchkey.asn1.Asn1Type;
import org.tomitribe.churchkey.asn1.Tag;
import org.tomitribe.churchkey.asn1.Utils;

public class DerParser
extends FilterInputStream {
    public static final int MAX_DER_VALUE_LENGTH = 65534;
    private final byte[] lenBytes = new byte[4];

    public DerParser(byte ... bytes) {
        this(bytes, 0, Utils.length(bytes));
    }

    public DerParser(byte[] bytes, int offset, int len) {
        this(new ByteArrayInputStream(bytes, offset, len));
    }

    public DerParser(InputStream s) {
        super(s);
    }

    public int readLength() throws IOException {
        int i = this.read();
        if (i == -1) {
            throw new StreamCorruptedException("Invalid DER: length missing");
        }
        if ((i & 0xFFFFFF80) == 0) {
            return i;
        }
        int num = i & 0x7F;
        if (i >= 255 || num > this.lenBytes.length) {
            throw new StreamCorruptedException("Invalid DER: length field too big: " + i);
        }
        Arrays.fill(this.lenBytes, (byte)0);
        int n = this.read(this.lenBytes, 4 - num, num);
        if (n < num) {
            throw new StreamCorruptedException("Invalid DER: length data too short: expected=" + num + ", actual=" + n);
        }
        long len = Utils.getUInt(this.lenBytes);
        if (len < 127L) {
            throw new StreamCorruptedException("Invalid DER: length not in shortest form: " + len);
        }
        if (len > 65534L) {
            throw new StreamCorruptedException("Invalid DER: data length too big: " + len + " (max=" + 65534 + ")");
        }
        return (int)len;
    }

    public DerParser readSequence() throws IOException {
        Asn1Object asn1Object = this.readObject();
        asn1Object.assertType(Asn1Type.SEQUENCE);
        return asn1Object.createParser();
    }

    public Asn1Object readObject() throws IOException {
        int tagDer = this.read();
        if (tagDer == -1) {
            return null;
        }
        Tag tag = Tag.fromDer(tagDer);
        if (tag.getType() == Asn1Type.NULL) {
            return new Asn1Object((byte)tagDer, 0, Utils.EMPTY_BYTE_ARRAY);
        }
        int length = this.readLength();
        byte[] value = new byte[length];
        int n = this.read(value);
        if (n < length) {
            throw new StreamCorruptedException("Invalid DER: stream too short, missing value: read " + n + " out of required " + length);
        }
        return new Asn1Object(tag, length, value);
    }

    public BigInteger readBigInteger() throws IOException {
        int type = this.read();
        if (type != 2) {
            throw new StreamCorruptedException("Invalid DER: data type is not an INTEGER: 0x" + Integer.toHexString(type));
        }
        int len = this.readLength();
        byte[] value = new byte[len];
        int n = this.read(value);
        if (n < len) {
            throw new StreamCorruptedException("Invalid DER: stream too short, missing value: read " + n + " out of required " + len);
        }
        return new BigInteger(value);
    }
}

