/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.dsa;

import java.math.BigInteger;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.Spec;

public class Dsa {

    public static class Private
    implements Spec<DSAPrivateKey, DSAPublicKey> {
        private BigInteger p;
        private BigInteger q;
        private BigInteger g;
        private BigInteger y;
        private BigInteger x;

        @Override
        public Spec<DSAPublicKey, DSAPublicKey> toPublic() {
            return Public.builder().g(this.g).p(this.p).q(this.q).y(this.y).build();
        }

        @Override
        public DSAPrivateKey toKey() {
            return (DSAPrivateKey)Key.Algorithm.DSA.getKeyFactory().generatePrivate(new DSAPrivateKeySpec(this.x, this.p, this.q, this.g));
        }

        Private(BigInteger p, BigInteger q, BigInteger g, BigInteger y, BigInteger x) {
            this.p = p;
            this.q = q;
            this.g = g;
            this.y = y;
            this.x = x;
        }

        public static Builder builder() {
            return new Builder();
        }

        public BigInteger getP() {
            return this.p;
        }

        public BigInteger getQ() {
            return this.q;
        }

        public BigInteger getG() {
            return this.g;
        }

        public BigInteger getY() {
            return this.y;
        }

        public BigInteger getX() {
            return this.x;
        }

        public void setP(BigInteger p) {
            this.p = p;
        }

        public void setQ(BigInteger q) {
            this.q = q;
        }

        public void setG(BigInteger g) {
            this.g = g;
        }

        public void setY(BigInteger y) {
            this.y = y;
        }

        public void setX(BigInteger x) {
            this.x = x;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Private)) {
                return false;
            }
            Private other = (Private)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$p = this.getP();
            BigInteger other$p = other.getP();
            if (this$p == null ? other$p != null : !((Object)this$p).equals(other$p)) {
                return false;
            }
            BigInteger this$q = this.getQ();
            BigInteger other$q = other.getQ();
            if (this$q == null ? other$q != null : !((Object)this$q).equals(other$q)) {
                return false;
            }
            BigInteger this$g = this.getG();
            BigInteger other$g = other.getG();
            if (this$g == null ? other$g != null : !((Object)this$g).equals(other$g)) {
                return false;
            }
            BigInteger this$y = this.getY();
            BigInteger other$y = other.getY();
            if (this$y == null ? other$y != null : !((Object)this$y).equals(other$y)) {
                return false;
            }
            BigInteger this$x = this.getX();
            BigInteger other$x = other.getX();
            return !(this$x == null ? other$x != null : !((Object)this$x).equals(other$x));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Private;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $p = this.getP();
            result = result * 59 + ($p == null ? 43 : ((Object)$p).hashCode());
            BigInteger $q = this.getQ();
            result = result * 59 + ($q == null ? 43 : ((Object)$q).hashCode());
            BigInteger $g = this.getG();
            result = result * 59 + ($g == null ? 43 : ((Object)$g).hashCode());
            BigInteger $y = this.getY();
            result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
            BigInteger $x = this.getX();
            result = result * 59 + ($x == null ? 43 : ((Object)$x).hashCode());
            return result;
        }

        public String toString() {
            return "Dsa.Private(p=" + this.getP() + ", q=" + this.getQ() + ", g=" + this.getG() + ", y=" + this.getY() + ", x=" + this.getX() + ")";
        }

        public static class Builder {
            private BigInteger p;
            private BigInteger q;
            private BigInteger g;
            private BigInteger y;
            private BigInteger x;

            Builder() {
            }

            public Builder p(BigInteger p) {
                this.p = p;
                return this;
            }

            public Builder q(BigInteger q) {
                this.q = q;
                return this;
            }

            public Builder g(BigInteger g) {
                this.g = g;
                return this;
            }

            public Builder y(BigInteger y) {
                this.y = y;
                return this;
            }

            public Builder x(BigInteger x) {
                this.x = x;
                return this;
            }

            public Private build() {
                return new Private(this.p, this.q, this.g, this.y, this.x);
            }

            public String toString() {
                return "Dsa.Private.Builder(p=" + this.p + ", q=" + this.q + ", g=" + this.g + ", y=" + this.y + ", x=" + this.x + ")";
            }
        }
    }

    public static class Public
    implements Spec<DSAPublicKey, DSAPublicKey> {
        private BigInteger y;
        private BigInteger p;
        private BigInteger q;
        private BigInteger g;

        @Override
        public Spec<DSAPublicKey, DSAPublicKey> toPublic() {
            return this;
        }

        @Override
        public DSAPublicKey toKey() {
            return (DSAPublicKey)Key.Algorithm.DSA.getKeyFactory().generatePublic(new DSAPublicKeySpec(this.y, this.p, this.q, this.g));
        }

        Public(BigInteger y, BigInteger p, BigInteger q, BigInteger g) {
            this.y = y;
            this.p = p;
            this.q = q;
            this.g = g;
        }

        public static Builder builder() {
            return new Builder();
        }

        public BigInteger getY() {
            return this.y;
        }

        public BigInteger getP() {
            return this.p;
        }

        public BigInteger getQ() {
            return this.q;
        }

        public BigInteger getG() {
            return this.g;
        }

        public void setY(BigInteger y) {
            this.y = y;
        }

        public void setP(BigInteger p) {
            this.p = p;
        }

        public void setQ(BigInteger q) {
            this.q = q;
        }

        public void setG(BigInteger g) {
            this.g = g;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Public)) {
                return false;
            }
            Public other = (Public)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$y = this.getY();
            BigInteger other$y = other.getY();
            if (this$y == null ? other$y != null : !((Object)this$y).equals(other$y)) {
                return false;
            }
            BigInteger this$p = this.getP();
            BigInteger other$p = other.getP();
            if (this$p == null ? other$p != null : !((Object)this$p).equals(other$p)) {
                return false;
            }
            BigInteger this$q = this.getQ();
            BigInteger other$q = other.getQ();
            if (this$q == null ? other$q != null : !((Object)this$q).equals(other$q)) {
                return false;
            }
            BigInteger this$g = this.getG();
            BigInteger other$g = other.getG();
            return !(this$g == null ? other$g != null : !((Object)this$g).equals(other$g));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Public;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $y = this.getY();
            result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
            BigInteger $p = this.getP();
            result = result * 59 + ($p == null ? 43 : ((Object)$p).hashCode());
            BigInteger $q = this.getQ();
            result = result * 59 + ($q == null ? 43 : ((Object)$q).hashCode());
            BigInteger $g = this.getG();
            result = result * 59 + ($g == null ? 43 : ((Object)$g).hashCode());
            return result;
        }

        public String toString() {
            return "Dsa.Public(y=" + this.getY() + ", p=" + this.getP() + ", q=" + this.getQ() + ", g=" + this.getG() + ")";
        }

        public static class Builder {
            private BigInteger y;
            private BigInteger p;
            private BigInteger q;
            private BigInteger g;

            Builder() {
            }

            public Builder y(BigInteger y) {
                this.y = y;
                return this;
            }

            public Builder p(BigInteger p) {
                this.p = p;
                return this;
            }

            public Builder q(BigInteger q) {
                this.q = q;
                return this;
            }

            public Builder g(BigInteger g) {
                this.g = g;
                return this;
            }

            public Public build() {
                return new Public(this.y, this.p, this.q, this.g);
            }

            public String toString() {
                return "Dsa.Public.Builder(y=" + this.y + ", p=" + this.p + ", q=" + this.q + ", g=" + this.g + ")";
            }
        }
    }
}

