/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.ec;

import java.math.BigInteger;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.Spec;
import org.tomitribe.churchkey.ec.Curve;

public class Ecdsa {

    public static class Private
    implements Spec<ECPrivateKey, ECPublicKey> {
        private final String curveName;
        private final Curve curve;
        private final BigInteger x;
        private final BigInteger y;
        private final BigInteger d;

        public Private(String curveName, Curve curve, BigInteger x, BigInteger y, BigInteger d) {
            this.x = x;
            this.y = y;
            this.d = d;
            if (curve == null && curveName == null) {
                throw new IllegalArgumentException("Curve or curveName must be specified");
            }
            if (curve == null) {
                curve = Curve.resolve(curveName);
            }
            if (curveName == null) {
                curveName = curve.name();
            }
            this.curveName = curveName;
            this.curve = curve;
        }

        @Override
        public Spec<ECPublicKey, ECPublicKey> toPublic() {
            return Public.builder().curveName(this.curveName).x(this.x).y(this.y).build();
        }

        @Override
        public ECPrivateKey toKey() {
            return (ECPrivateKey)Key.Algorithm.EC.getKeyFactory().generatePrivate(new ECPrivateKeySpec(this.d, this.curve.getParameterSpec()));
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getCurveName() {
            return this.curveName;
        }

        public Curve getCurve() {
            return this.curve;
        }

        public BigInteger getX() {
            return this.x;
        }

        public BigInteger getY() {
            return this.y;
        }

        public BigInteger getD() {
            return this.d;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Private)) {
                return false;
            }
            Private other = (Private)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$curveName = this.getCurveName();
            String other$curveName = other.getCurveName();
            if (this$curveName == null ? other$curveName != null : !this$curveName.equals(other$curveName)) {
                return false;
            }
            Curve this$curve = this.getCurve();
            Curve other$curve = other.getCurve();
            if (this$curve == null ? other$curve != null : !((Object)((Object)this$curve)).equals((Object)other$curve)) {
                return false;
            }
            BigInteger this$x = this.getX();
            BigInteger other$x = other.getX();
            if (this$x == null ? other$x != null : !((Object)this$x).equals(other$x)) {
                return false;
            }
            BigInteger this$y = this.getY();
            BigInteger other$y = other.getY();
            if (this$y == null ? other$y != null : !((Object)this$y).equals(other$y)) {
                return false;
            }
            BigInteger this$d = this.getD();
            BigInteger other$d = other.getD();
            return !(this$d == null ? other$d != null : !((Object)this$d).equals(other$d));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Private;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $curveName = this.getCurveName();
            result = result * 59 + ($curveName == null ? 43 : $curveName.hashCode());
            Curve $curve = this.getCurve();
            result = result * 59 + ($curve == null ? 43 : ((Object)((Object)$curve)).hashCode());
            BigInteger $x = this.getX();
            result = result * 59 + ($x == null ? 43 : ((Object)$x).hashCode());
            BigInteger $y = this.getY();
            result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
            BigInteger $d = this.getD();
            result = result * 59 + ($d == null ? 43 : ((Object)$d).hashCode());
            return result;
        }

        public String toString() {
            return "Ecdsa.Private(curveName=" + this.getCurveName() + ", curve=" + (Object)((Object)this.getCurve()) + ", x=" + this.getX() + ", y=" + this.getY() + ", d=" + this.getD() + ")";
        }

        public static class Builder {
            private String curveName;
            private Curve curve;
            private BigInteger x;
            private BigInteger y;
            private BigInteger d;

            Builder() {
            }

            public Builder curveName(String curveName) {
                this.curveName = curveName;
                return this;
            }

            public Builder curve(Curve curve) {
                this.curve = curve;
                return this;
            }

            public Builder x(BigInteger x) {
                this.x = x;
                return this;
            }

            public Builder y(BigInteger y) {
                this.y = y;
                return this;
            }

            public Builder d(BigInteger d) {
                this.d = d;
                return this;
            }

            public Private build() {
                return new Private(this.curveName, this.curve, this.x, this.y, this.d);
            }

            public String toString() {
                return "Ecdsa.Private.Builder(curveName=" + this.curveName + ", curve=" + (Object)((Object)this.curve) + ", x=" + this.x + ", y=" + this.y + ", d=" + this.d + ")";
            }
        }
    }

    public static class Public
    implements Spec<ECPublicKey, ECPublicKey> {
        private final String curveName;
        private final Curve curve;
        private final BigInteger x;
        private final BigInteger y;

        public Public(String curveName, Curve curve, BigInteger x, BigInteger y) {
            this.x = x;
            this.y = y;
            if (curve == null && curveName == null) {
                throw new IllegalArgumentException("Curve or curveName must be specified");
            }
            if (curve == null) {
                curve = Curve.resolve(curveName);
            }
            if (curveName == null) {
                curveName = curve.name();
            }
            this.curveName = curveName;
            this.curve = curve;
        }

        @Override
        public Spec<ECPublicKey, ECPublicKey> toPublic() {
            return this;
        }

        @Override
        public ECPublicKey toKey() {
            return (ECPublicKey)Key.Algorithm.EC.getKeyFactory().generatePublic(new ECPublicKeySpec(new ECPoint(this.x, this.y), this.curve.getParameterSpec()));
        }

        public static Builder builder() {
            return new Builder();
        }

        public String getCurveName() {
            return this.curveName;
        }

        public Curve getCurve() {
            return this.curve;
        }

        public BigInteger getX() {
            return this.x;
        }

        public BigInteger getY() {
            return this.y;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Public)) {
                return false;
            }
            Public other = (Public)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$curveName = this.getCurveName();
            String other$curveName = other.getCurveName();
            if (this$curveName == null ? other$curveName != null : !this$curveName.equals(other$curveName)) {
                return false;
            }
            Curve this$curve = this.getCurve();
            Curve other$curve = other.getCurve();
            if (this$curve == null ? other$curve != null : !((Object)((Object)this$curve)).equals((Object)other$curve)) {
                return false;
            }
            BigInteger this$x = this.getX();
            BigInteger other$x = other.getX();
            if (this$x == null ? other$x != null : !((Object)this$x).equals(other$x)) {
                return false;
            }
            BigInteger this$y = this.getY();
            BigInteger other$y = other.getY();
            return !(this$y == null ? other$y != null : !((Object)this$y).equals(other$y));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Public;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $curveName = this.getCurveName();
            result = result * 59 + ($curveName == null ? 43 : $curveName.hashCode());
            Curve $curve = this.getCurve();
            result = result * 59 + ($curve == null ? 43 : ((Object)((Object)$curve)).hashCode());
            BigInteger $x = this.getX();
            result = result * 59 + ($x == null ? 43 : ((Object)$x).hashCode());
            BigInteger $y = this.getY();
            result = result * 59 + ($y == null ? 43 : ((Object)$y).hashCode());
            return result;
        }

        public String toString() {
            return "Ecdsa.Public(curveName=" + this.getCurveName() + ", curve=" + (Object)((Object)this.getCurve()) + ", x=" + this.getX() + ", y=" + this.getY() + ")";
        }

        public static class Builder {
            private String curveName;
            private Curve curve;
            private BigInteger x;
            private BigInteger y;

            Builder() {
            }

            public Builder curveName(String curveName) {
                this.curveName = curveName;
                return this;
            }

            public Builder curve(Curve curve) {
                this.curve = curve;
                return this;
            }

            public Builder x(BigInteger x) {
                this.x = x;
                return this;
            }

            public Builder y(BigInteger y) {
                this.y = y;
                return this;
            }

            public Public build() {
                return new Public(this.curveName, this.curve, this.x, this.y);
            }

            public String toString() {
                return "Ecdsa.Public.Builder(curveName=" + this.curveName + ", curve=" + (Object)((Object)this.curve) + ", x=" + this.x + ", y=" + this.y + ")";
            }
        }
    }
}

