/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.jwk;

import java.util.Arrays;
import java.util.List;
import org.tomitribe.util.Join;

public class InvalidJwkKeySpecException
extends IllegalArgumentException {
    private final String kty;
    private final List<String> missing;

    public InvalidJwkKeySpecException(String kty, String ... missing) {
        this(kty, Arrays.asList(missing));
    }

    public InvalidJwkKeySpecException(String kty, List<String> missing) {
        this.kty = kty;
        this.missing = missing;
    }

    public List<String> getMissing() {
        return this.missing;
    }

    public String getKty() {
        return this.kty;
    }

    @Override
    public String getMessage() {
        return String.format("Invalid %s JWK: missing required attributes: %s", this.kty, Join.join((String)", ", this.missing));
    }
}

