/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.jwk;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonValue;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.dsa.Dsa;
import org.tomitribe.churchkey.ec.Curve;
import org.tomitribe.churchkey.ec.ECParameterSpecs;
import org.tomitribe.churchkey.ec.Ecdsa;
import org.tomitribe.churchkey.ec.UnsupportedCurveException;
import org.tomitribe.churchkey.jwk.InvalidJwkException;
import org.tomitribe.churchkey.jwk.InvalidJwkKeySpecException;
import org.tomitribe.churchkey.jwk.MissingKtyException;
import org.tomitribe.churchkey.jwk.UnknownJsonFormatFoundException;
import org.tomitribe.churchkey.jwk.UnsupportedKtyAlgorithmException;
import org.tomitribe.churchkey.util.Utils;
import org.tomitribe.util.IO;

public class JwkParser
implements Key.Format.Parser {
    @Override
    public Key decode(byte[] bytes) {
        byte[] decoded = this.normalize(bytes);
        if (!Utils.startsWith("{", decoded)) {
            return null;
        }
        String rawJson = new String(decoded);
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("org.apache.johnzon.buffer-strategy", "BY_INSTANCE");
        JsonReaderFactory factory = Json.createReaderFactory(config);
        JsonReader reader = factory.createReader(IO.read((byte[])decoded));
        try {
            JsonObject jsonObject = reader.readObject();
            JsonObject jwk = this.getJwk(jsonObject);
            if (!jwk.containsKey((Object)"kty")) {
                throw new MissingKtyException();
            }
            String kty = jwk.getString("kty");
            if ("RSA".equalsIgnoreCase(kty)) {
                return this.asRsaKey(jwk);
            }
            if ("OCT".equalsIgnoreCase(kty)) {
                return this.asOctKey(jwk);
            }
            if ("DSA".equals(kty)) {
                return this.asDsaKey(jwk);
            }
            if ("EC".equals(kty)) {
                return this.asEcKey(jwk);
            }
            throw new UnsupportedKtyAlgorithmException(kty);
        }
        catch (Exception e) {
            throw new InvalidJwkException(e, rawJson);
        }
    }

    private Key asDsaKey(JsonObject jsonObject) {
        Jwk jwk = new Jwk(jsonObject);
        BigInteger p = jwk.getBigInteger("p");
        BigInteger q = jwk.getBigInteger("q");
        BigInteger g = jwk.getBigInteger("g");
        BigInteger x = jwk.getBigInteger("x");
        BigInteger y = jwk.getBigInteger("y");
        ArrayList<String> missing = new ArrayList<String>();
        if (p == null) {
            missing.add("p");
        }
        if (q == null) {
            missing.add("q");
        }
        if (g == null) {
            missing.add("g");
        }
        if (missing.size() != 0) {
            throw new InvalidJwkKeySpecException("DSA", missing);
        }
        if (x != null) {
            DSAPrivateKey privateKey = Dsa.Private.builder().p(p).q(q).g(g).x(x).build().toKey();
            Map<String, String> attributes = this.getAttributes(jsonObject, "kty", "p", "q", "q", "x", "y");
            return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.DSA, Key.Format.JWK, attributes);
        }
        if (y != null) {
            DSAPublicKey publicKey = Dsa.Public.builder().p(p).q(q).g(g).y(y).build().toKey();
            Map<String, String> attributes = this.getAttributes(jsonObject, "kty", "p", "q", "q", "x", "y");
            return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.DSA, Key.Format.JWK, attributes);
        }
        throw new InvalidJwkKeySpecException("DSA", "x", "y");
    }

    private Key asEcKey(JsonObject jsonObject) {
        Jwk jwk = new Jwk(jsonObject);
        String crv = jwk.getString("crv");
        BigInteger d = jwk.getBigInteger("d");
        BigInteger x = jwk.getBigInteger("x");
        BigInteger y = jwk.getBigInteger("y");
        if (crv == null) {
            throw new InvalidJwkKeySpecException("EC", "crv");
        }
        Curve curve = Curve.resolve(crv);
        if (d != null) {
            ECPrivateKey privateKey = Ecdsa.Private.builder().curve(curve).d(d).build().toKey();
            Map<String, String> attributes = this.getAttributes(jsonObject, "kty", "crv", "d");
            return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.EC, Key.Format.JWK, attributes);
        }
        ArrayList<String> missing = new ArrayList<String>();
        if (y == null) {
            missing.add("y");
        }
        if (x == null) {
            missing.add("x");
        }
        if (missing.size() != 0) {
            throw new InvalidJwkKeySpecException("EC", missing);
        }
        ECPublicKey publicKey = Ecdsa.Public.builder().curve(curve).x(x).y(y).build().toKey();
        Map<String, String> attributes = this.getAttributes(jsonObject, "kty", "crv", "x", "y");
        return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.EC, Key.Format.JWK, attributes);
    }

    private Key asRsaKey(JsonObject jsonObject) throws NoSuchAlgorithmException, InvalidKeySpecException {
        Jwk jwk = new Jwk(jsonObject);
        BigInteger modulus = jwk.getBigInteger("n");
        BigInteger publicExp = jwk.getBigInteger("e");
        BigInteger privateExp = jwk.getBigInteger("d");
        BigInteger primeP = jwk.getBigInteger("p");
        BigInteger primeQ = jwk.getBigInteger("q");
        BigInteger primeExponentP = jwk.getBigInteger("dp");
        BigInteger primeExponentQ = jwk.getBigInteger("dq");
        BigInteger crtCoef = jwk.getBigInteger("qi");
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, publicExp);
        RSAPrivateCrtKeySpec rsaPrivateKeySpec = new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, primeP, primeQ, primeExponentP, primeExponentQ, crtCoef);
        this.checkPublicKey(rsaPublicKeySpec);
        this.checkPrivateKey(rsaPrivateKeySpec);
        KeyFactory result = KeyFactory.getInstance("RSA");
        if (privateExp != null) {
            PrivateKey privateKey = result.generatePrivate(rsaPrivateKeySpec);
            Map<String, String> attributes = this.getAttributes(jsonObject, "kty", "n", "e", "d", "p", "q", "dp", "dq", "qi");
            return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.JWK, attributes);
        }
        PublicKey publicKey = result.generatePublic(rsaPublicKeySpec);
        Map<String, String> attributes = this.getAttributes(jsonObject, "kty", "n", "e");
        return new Key(publicKey, Key.Type.PUBLIC, Key.Algorithm.RSA, Key.Format.JWK, attributes);
    }

    private void toRsaKey(Key key, JsonObjectBuilder jwk) {
        if (key.getKey() instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)key.getKey();
            jwk.add("n", JwkParser.encode(privateKey.getModulus()));
            jwk.add("e", JwkParser.encode(privateKey.getPublicExponent()));
            jwk.add("d", JwkParser.encode(privateKey.getPrivateExponent()));
            jwk.add("p", JwkParser.encode(privateKey.getPrimeP()));
            jwk.add("q", JwkParser.encode(privateKey.getPrimeQ()));
            jwk.add("dp", JwkParser.encode(privateKey.getPrimeExponentP()));
            jwk.add("dq", JwkParser.encode(privateKey.getPrimeExponentQ()));
            jwk.add("qi", JwkParser.encode(privateKey.getCrtCoefficient()));
        } else if (key.getKey() instanceof RSAPrivateKey) {
            RSAPrivateKey privateKey = (RSAPrivateKey)key.getKey();
            jwk.add("n", JwkParser.encode(privateKey.getModulus()));
            jwk.add("d", JwkParser.encode(privateKey.getPrivateExponent()));
        } else if (key.getKey() instanceof RSAPublicKey) {
            RSAPublicKey publicKey = (RSAPublicKey)key.getKey();
            jwk.add("n", JwkParser.encode(publicKey.getModulus()));
            jwk.add("e", JwkParser.encode(publicKey.getPublicExponent()));
        } else {
            throw new UnsupportedOperationException("Unkown RSA Key type: " + key.getKey().getClass().getName());
        }
        jwk.add("kty", "RSA");
    }

    private void toDsaKey(Key key, JsonObjectBuilder jwk) {
        if (key.getKey() instanceof DSAPrivateKey) {
            DSAPrivateKey privateKey = (DSAPrivateKey)key.getKey();
            jwk.add("x", JwkParser.encode(privateKey.getX()));
            jwk.add("p", JwkParser.encode(privateKey.getParams().getP()));
            jwk.add("q", JwkParser.encode(privateKey.getParams().getQ()));
            jwk.add("g", JwkParser.encode(privateKey.getParams().getG()));
        } else if (key.getKey() instanceof DSAPublicKey) {
            DSAPublicKey privateKey = (DSAPublicKey)key.getKey();
            jwk.add("y", JwkParser.encode(privateKey.getY()));
            jwk.add("p", JwkParser.encode(privateKey.getParams().getP()));
            jwk.add("q", JwkParser.encode(privateKey.getParams().getQ()));
            jwk.add("g", JwkParser.encode(privateKey.getParams().getG()));
        } else {
            throw new UnsupportedOperationException("Unkown DSA Key type: " + key.getKey().getClass().getName());
        }
        jwk.add("kty", "DSA");
    }

    private void toEcKey(Key key, JsonObjectBuilder jwk) {
        if (key.getKey() instanceof ECPrivateKey) {
            ECPrivateKey privateKey = (ECPrivateKey)key.getKey();
            jwk.add("d", JwkParser.encode(privateKey.getS()));
            jwk.add("crv", this.curveName(privateKey.getParams()));
        } else if (key.getKey() instanceof ECPublicKey) {
            ECPublicKey publicKey = (ECPublicKey)key.getKey();
            ECPoint point = publicKey.getW();
            jwk.add("y", JwkParser.encode(point.getAffineY()));
            jwk.add("x", JwkParser.encode(point.getAffineX()));
            jwk.add("crv", this.curveName(publicKey.getParams()));
        } else {
            throw new UnsupportedOperationException("Unkown EC Key type: " + key.getKey().getClass().getName());
        }
        jwk.add("kty", "EC");
    }

    private String curveName(ECParameterSpec spec) {
        if (Curve.p256.isEqual(spec)) {
            return "P-256";
        }
        if (Curve.p384.isEqual(spec)) {
            return "P-384";
        }
        if (Curve.p521.isEqual(spec)) {
            return "P-521";
        }
        for (Curve curve : Curve.values()) {
            if (!curve.isEqual(spec)) continue;
            return curve.getName();
        }
        String s = ECParameterSpecs.toString(spec);
        throw new UnsupportedCurveException(String.format("The specified ECParameterSpec has no known name.  Params:%n%s", s));
    }

    private Key asOctKey(JsonObject jwkObject) {
        Jwk jwk = new Jwk(jwkObject);
        byte[] keyBytes = jwk.getBytes("k");
        String alg = jwk.getString("alg", "HS256").toUpperCase();
        String jmvAlg = alg.replace("HS", "HmacSHA");
        SecretKeySpec keySpec = new SecretKeySpec(keyBytes, jmvAlg);
        Map<String, String> attributes = this.getAttributes(jwkObject, "kty", "k");
        return new Key(keySpec, Key.Type.SECRET, Key.Algorithm.OCT, Key.Format.JWK, attributes);
    }

    private void toOctKey(Key key, JsonObjectBuilder jwk) {
        if (!(key.getKey() instanceof SecretKey)) {
            throw new UnsupportedOperationException("Unkown RSA Key type: " + key.getKey().getClass().getName());
        }
        SecretKey publicKey = (SecretKey)key.getKey();
        jwk.add("k", JwkParser.encode(publicKey.getEncoded()));
        jwk.add("kty", "oct");
    }

    private Map<String, String> getAttributes(JsonObject jwkObject, String ... excludes) {
        return this.getAttributes(jwkObject, Arrays.asList(excludes));
    }

    private Map<String, String> getAttributes(JsonObject jwkObject, Collection<String> excludes) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : jwkObject.entrySet()) {
            if (excludes.contains(entry.getKey())) continue;
            map.put((String)entry.getKey(), this.toString((JsonValue)entry.getValue()));
        }
        return map;
    }

    private String toString(JsonValue value) {
        switch (value.getValueType()) {
            case STRING: {
                String string = value.toString();
                return string.substring(1, string.length() - 1);
            }
            case NULL: {
                return null;
            }
        }
        return value.toString();
    }

    private void checkPublicKey(RSAPublicKeySpec spec) {
        ArrayList<String> missing = new ArrayList<String>();
        if (spec.getModulus() == null) {
            missing.add("n");
        }
        if (spec.getPublicExponent() == null) {
            missing.add("e");
        }
        if (missing.size() > 0) {
            throw new InvalidJwkKeySpecException("rsa", missing);
        }
    }

    private void checkPrivateKey(RSAPrivateCrtKeySpec spec) {
        ArrayList<String> missing = new ArrayList<String>();
        if (spec.getPrivateExponent() == null) {
            missing.add("d");
        }
        if (spec.getPrimeP() == null) {
            missing.add("p");
        }
        if (spec.getPrimeQ() == null) {
            missing.add("q");
        }
        if (spec.getPrimeExponentP() == null) {
            missing.add("dp");
        }
        if (spec.getPrimeExponentQ() == null) {
            missing.add("dq");
        }
        if (spec.getCrtCoefficient() == null) {
            missing.add("qi");
        }
        if (missing.size() == 6) {
            return;
        }
        if (missing.size() == 0) {
            return;
        }
        throw new InvalidJwkKeySpecException("rsa", missing);
    }

    public static String encode(BigInteger bigInteger) {
        Base64.Encoder urlEncoder = Base64.getUrlEncoder().withoutPadding();
        byte[] bytes = bigInteger.toByteArray();
        if (bytes[0] == 0) {
            byte[] trimmed = new byte[bytes.length - 1];
            System.arraycopy(bytes, 1, trimmed, 0, trimmed.length);
            return urlEncoder.encodeToString(trimmed);
        }
        return urlEncoder.encodeToString(bytes);
    }

    public static String encode(byte[] bytes) {
        Base64.Encoder urlEncoder = Base64.getUrlEncoder().withoutPadding();
        return urlEncoder.encodeToString(bytes);
    }

    private JsonObject getJwk(JsonObject jsonObject) {
        if (jsonObject.containsKey((Object)"keys")) {
            return this.getJwkFromJwks(jsonObject);
        }
        if (jsonObject.containsKey((Object)"kty")) {
            return jsonObject;
        }
        throw new UnknownJsonFormatFoundException();
    }

    private JsonObject getJwkFromJwks(JsonObject jwks) {
        JsonValue keys = jwks.getValue("keys");
        if (keys == null) {
            throw new IllegalArgumentException("Invalid JWKS; 'keys' entry is missing.");
        }
        switch (keys.getValueType()) {
            case ARRAY: {
                return this.getFirstJwk(jwks, keys.asJsonArray());
            }
            case OBJECT: {
                return keys.asJsonObject();
            }
        }
        throw new IllegalArgumentException("Invalid JWKS; 'keys' entry should be an array.");
    }

    private JsonObject getFirstJwk(JsonObject jwks, JsonArray keys) {
        if (keys.size() == 0) {
            throw new IllegalArgumentException("Invalid JWKS; 'keys' entry is empty.\n" + jwks.toString());
        }
        JsonValue value = (JsonValue)keys.get(0);
        if (!JsonValue.ValueType.OBJECT.equals((Object)value.getValueType())) {
            throw new IllegalArgumentException("Invalid JWKS; 'keys' array should contain jwk objects.\n" + jwks.toString());
        }
        return value.asJsonObject();
    }

    private byte[] normalize(byte[] bytes) {
        if (!Utils.startsWith("e", bytes)) {
            return bytes;
        }
        if (Utils.startsWith("ecdsa", bytes)) {
            return bytes;
        }
        return Base64.getUrlDecoder().decode(bytes);
    }

    @Override
    public byte[] encode(Key key) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, String> entry : key.getAttributes().entrySet()) {
            builder.add(entry.getKey(), entry.getValue());
        }
        switch (key.getAlgorithm()) {
            case RSA: {
                this.toRsaKey(key, builder);
                break;
            }
            case DSA: {
                this.toDsaKey(key, builder);
                break;
            }
            case EC: {
                this.toEcKey(key, builder);
                break;
            }
            case OCT: {
                this.toOctKey(key, builder);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot encode key type: " + (Object)((Object)key.getAlgorithm()));
            }
        }
        JsonObject build = builder.build();
        return build.toString().getBytes();
    }

    private static class Jwk {
        private final JsonObject jwk;

        public Jwk(JsonObject jwk) {
            this.jwk = jwk;
        }

        public BigInteger getBigInteger(String name) {
            if (!this.jwk.containsKey((Object)name)) {
                return null;
            }
            String string = this.jwk.getString(name);
            Base64.Decoder urlDecoder = Base64.getUrlDecoder();
            byte[] bytes = urlDecoder.decode(string);
            return new BigInteger(1, bytes);
        }

        public byte[] getBytes(String name) {
            if (!this.jwk.containsKey((Object)name)) {
                return null;
            }
            String string = this.jwk.getString(name);
            Base64.Decoder urlDecoder = Base64.getUrlDecoder();
            return urlDecoder.decode(string);
        }

        public String getString(String s) {
            return this.jwk.getString(s);
        }

        public String getString(String s, String s1) {
            return this.jwk.getString(s, s1);
        }
    }
}

