/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.pem;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.interfaces.DSAPrivateKey;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.asn1.Asn1Object;
import org.tomitribe.churchkey.asn1.Asn1Type;
import org.tomitribe.churchkey.asn1.DerParser;
import org.tomitribe.churchkey.dsa.Dsa;

public class BeginDsaPrivateKey {
    private BeginDsaPrivateKey() {
    }

    public static Key decode(byte[] bytes) {
        try {
            DerParser parser = new DerParser(bytes);
            Asn1Object sequence = parser.readObject();
            if (sequence.getType() != Asn1Type.SEQUENCE) {
                throw new IllegalArgumentException("Invalid DER: not a sequence");
            }
            DerParser parser1 = sequence.createParser();
            parser1.readObject();
            DSAPrivateKey privateKey = Dsa.Private.builder().p(parser1.readObject().asInteger()).q(parser1.readObject().asInteger()).g(parser1.readObject().asInteger()).y(parser1.readObject().asInteger()).x(parser1.readObject().asInteger()).build().toKey();
            return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.DSA, Key.Format.PEM);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] encode(Key key) {
        return null;
    }
}

