/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.pem;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.math.BigInteger;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.asn1.Asn1Object;
import org.tomitribe.churchkey.asn1.Asn1Type;
import org.tomitribe.churchkey.asn1.DerParser;
import org.tomitribe.churchkey.asn1.DerWriter;
import org.tomitribe.churchkey.asn1.Oid;
import org.tomitribe.churchkey.dsa.Dsa;
import org.tomitribe.churchkey.ec.Curve;
import org.tomitribe.churchkey.ec.Ecdsa;
import org.tomitribe.churchkey.ec.UnsupportedCurveException;
import org.tomitribe.churchkey.rsa.Rsa;
import org.tomitribe.churchkey.util.Pem;

public class BeginPrivateKey {
    private static final Oid rsaKey = Oid.fromString("1.2.840.113549.1.1.1");
    private static final Oid dsaKey = Oid.fromString("1.2.840.10040.4.1");
    private static final Oid ecKey = Oid.fromString("1.2.840.10045.2.1");

    private BeginPrivateKey() {
    }

    public static Key decode(byte[] bytes) {
        try {
            Oid keyTypeOid = BeginPrivateKey.readKeyType(bytes);
            if (rsaKey.equals(keyTypeOid)) {
                return BeginPrivateKey.decodeRsaKey(bytes);
            }
            if (dsaKey.equals(keyTypeOid)) {
                return BeginPrivateKey.decodeDsaKey(bytes);
            }
            if (ecKey.equals(keyTypeOid)) {
                return BeginPrivateKey.decodeEcKey(bytes);
            }
            throw new UnsupportedOperationException("Unsupported key type oid: " + keyTypeOid);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Key decodeRsaKey(byte[] bytes) throws IOException {
        DerParser d1 = new DerParser(bytes);
        Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d2 = new DerParser(d1o1.getValue());
        Asn1Object d2o1 = d2.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d2o2 = d2.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d3 = new DerParser(d2o2.getValue());
        Asn1Object d3o1 = d3.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
        Asn1Object asn1Object = d3.readObject().assertType(Asn1Type.NULL);
        Asn1Object d2o3 = d2.readObject().assertType(Asn1Type.OCTET_STRING);
        DerParser d32 = new DerParser(d2o3.getValue());
        Asn1Object d3o12 = d32.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d4 = new DerParser(d3o12.getValue());
        BigInteger version = d4.readBigInteger();
        RSAPrivateCrtKey privateKey = Rsa.Private.builder().modulus(d4.readBigInteger()).publicExponent(d4.readBigInteger()).privateExponent(d4.readBigInteger()).primeP(d4.readBigInteger()).primeQ(d4.readBigInteger()).primeExponentP(d4.readBigInteger()).primeExponentQ(d4.readBigInteger()).crtCoefficient(d4.readBigInteger()).build().toKey();
        return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.PEM);
    }

    private static Key decodeDsaKey(byte[] bytes) throws IOException {
        Dsa.Private.Builder dsa = Dsa.Private.builder();
        DerParser d1 = new DerParser(bytes);
        Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d2 = new DerParser(d1o1.getValue());
        Asn1Object d2o1 = d2.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d2o2 = d2.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d3 = new DerParser(d2o2.getValue());
        Asn1Object d3o1 = d3.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
        Asn1Object d3o2 = d3.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d4 = new DerParser(d3o2.getValue());
        dsa.p(d4.readBigInteger());
        dsa.q(d4.readBigInteger());
        dsa.g(d4.readBigInteger());
        Asn1Object d2o3 = d2.readObject().assertType(Asn1Type.OCTET_STRING);
        DerParser d32 = new DerParser(d2o3.getValue());
        dsa.x(d32.readBigInteger());
        DSAPrivateKey privateKey = dsa.build().toKey();
        return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.DSA, Key.Format.PEM);
    }

    private static Key decodeEcKey(byte[] bytes) throws IOException {
        Ecdsa.Private.Builder ecdsa = Ecdsa.Private.builder();
        DerParser d1 = new DerParser(bytes);
        Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d2 = new DerParser(d1o1.getValue());
        Asn1Object d2o1 = d2.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d2o2 = d2.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d3 = new DerParser(d2o2.getValue());
        Asn1Object d3o1 = d3.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
        Asn1Object d3o2 = d3.readObject();
        if (d3o2.isType(Asn1Type.OBJECT_IDENTIFIER)) {
            Oid oid = d3o2.asOID();
            Curve curve = Curve.resolve(oid);
            if (curve == null) {
                throw new UnsupportedCurveException(oid.toString());
            }
            ecdsa.curve(curve);
        } else if (d3o2.isType(Asn1Type.SEQUENCE)) {
            throw new UnsupportedOperationException("Explicit parameters in EC keys is not supported");
        }
        Asn1Object d2o3 = d2.readObject().assertType(Asn1Type.OCTET_STRING);
        DerParser d32 = new DerParser(d2o3.getValue());
        Asn1Object d3o12 = d32.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d4 = new DerParser(d3o12.getValue());
        Asn1Object d4o1 = d4.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d4o2 = d4.readObject().assertType(Asn1Type.OCTET_STRING);
        ecdsa.d(new BigInteger(d4o2.getValue()));
        ECPrivateKey privateKey = ecdsa.build().toKey();
        return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.EC, Key.Format.PEM);
    }

    private static Oid readKeyType(byte[] bytes) throws IOException {
        DerParser d1 = new DerParser(bytes);
        Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d2 = new DerParser(d1o1.getValue());
        Asn1Object d2o1 = d2.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d2o2 = d2.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d3 = new DerParser(d2o2.getValue());
        Asn1Object d3o1 = d3.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
        return d3o1.asOID();
    }

    public static byte[] encode(Key key) {
        byte[] derEncodedBytes = BeginPrivateKey.toDer(key);
        return Pem.builder().type("PRIVATE KEY").data(derEncodedBytes).wrap(64).format().getBytes();
    }

    public static byte[] toDer(Key key) {
        if (key.getAlgorithm() == Key.Algorithm.RSA) {
            RSAPrivateCrtKey privateKey = (RSAPrivateCrtKey)key.getKey();
            return DerWriter.write().sequence(DerWriter.write().bigInteger(BigInteger.ZERO).sequence(DerWriter.write().objectIdentifier(rsaKey).nill()).octetString(DerWriter.write().sequence(DerWriter.write().bigInteger(BigInteger.ZERO).bigInteger(privateKey.getModulus()).bigInteger(privateKey.getPublicExponent()).bigInteger(privateKey.getPrivateExponent()).bigInteger(privateKey.getPrimeP()).bigInteger(privateKey.getPrimeQ()).bigInteger(privateKey.getPrimeExponentP()).bigInteger(privateKey.getPrimeExponentQ()).bigInteger(privateKey.getCrtCoefficient())))).bytes();
        }
        if (key.getAlgorithm() == Key.Algorithm.DSA) {
            DSAPrivateKey privateKey = (DSAPrivateKey)key.getKey();
            return DerWriter.write().sequence(DerWriter.write().bigInteger(BigInteger.ZERO).sequence(DerWriter.write().objectIdentifier(dsaKey).sequence(DerWriter.write().bigInteger(privateKey.getParams().getP()).bigInteger(privateKey.getParams().getQ()).bigInteger(privateKey.getParams().getG()))).octetString(DerWriter.write().bigInteger(privateKey.getX()))).bytes();
        }
        return null;
    }
}

