/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.pem;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.interfaces.RSAPrivateCrtKey;
import org.tomitribe.churchkey.Key;
import org.tomitribe.churchkey.asn1.Asn1Object;
import org.tomitribe.churchkey.asn1.Asn1Type;
import org.tomitribe.churchkey.asn1.DerParser;
import org.tomitribe.churchkey.rsa.Rsa;

public class BeginRsaPrivateKey {
    private BeginRsaPrivateKey() {
    }

    public static Key decode(byte[] bytes) {
        try {
            DerParser parser = new DerParser(bytes);
            Asn1Object sequence = parser.readObject();
            if (sequence.getType() != Asn1Type.SEQUENCE) {
                throw new IllegalArgumentException("Invalid DER: not a sequence");
            }
            DerParser p = sequence.createParser();
            p.readObject();
            RSAPrivateCrtKey privateKey = Rsa.Private.builder().modulus(p.readObject().asInteger()).publicExponent(p.readObject().asInteger()).privateExponent(p.readObject().asInteger()).primeP(p.readObject().asInteger()).primeQ(p.readObject().asInteger()).primeExponentP(p.readObject().asInteger()).primeExponentQ(p.readObject().asInteger()).crtCoefficient(p.readObject().asInteger()).build().toKey();
            return new Key(privateKey, Key.Type.PRIVATE, Key.Algorithm.RSA, Key.Format.PEM);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] encode(Key key) {
        return null;
    }
}

