/*
 * Decompiled with CFR 0.152.
 */
package org.tomitribe.churchkey.pem;

import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.tomitribe.churchkey.asn1.Asn1Object;
import org.tomitribe.churchkey.asn1.Asn1Type;
import org.tomitribe.churchkey.asn1.DerParser;
import org.tomitribe.churchkey.asn1.Oid;
import org.tomitribe.churchkey.ssh.OpenSSHPrivateKey;
import org.tomitribe.churchkey.util.Pem;
import org.tomitribe.churchkey.util.Utils;

public class EcCurveParams {
    private static final Oid primeField = new Oid(1, 2, 840, 10045, 1, 1);
    private static final Oid characteristicTwoField = new Oid(1, 2, 840, 10045, 1, 2);
    private static final Oid tpBasis = new Oid(1, 2, 840, 10045, 1, 2, 3, 2);
    private static final Oid ppBasis = new Oid(1, 2, 840, 10045, 1, 2, 3, 3);

    private EcCurveParams() {
    }

    public static Oid parseOid(byte[] data) throws IOException {
        if (Utils.startsWith("-----BEGIN EC PARAMETERS-----", data)) {
            Pem pem = Pem.parse(data);
            return EcCurveParams.parseOid(pem.getData());
        }
        DerParser d1 = new DerParser(data);
        Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
        return d1o1.asOID();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ECParameterSpec parse(byte[] data) throws IOException {
        void var3_15;
        Asn1Object d3o2;
        if (Utils.startsWith("-----BEGIN EC PARAMETERS-----", data)) {
            Pem pem = Pem.parse(data);
            return EcCurveParams.parse(pem.getData());
        }
        DerParser d1 = new DerParser(data);
        Asn1Object d1o1 = d1.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d2 = new DerParser(d1o1.getValue());
        Asn1Object d2o1 = d2.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d2o2 = d2.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d3 = new DerParser(d2o2.getValue());
        Asn1Object d3o1 = d3.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
        Oid oid = d3o1.asOID();
        if (primeField.equals(oid)) {
            d3o2 = d3.readObject().assertType(Asn1Type.INTEGER);
            ECFieldFp eCFieldFp = new ECFieldFp(d3o2.toInteger());
        } else {
            if (!characteristicTwoField.equals(oid)) throw new UnsupportedOperationException(oid.toString());
            d3o2 = d3.readObject().assertType(Asn1Type.SEQUENCE);
            DerParser d4 = new DerParser(d3o2.getValue());
            Asn1Object d4o1 = d4.readObject().assertType(Asn1Type.INTEGER);
            Asn1Object d4o2 = d4.readObject().assertType(Asn1Type.OBJECT_IDENTIFIER);
            Oid basis = d4o2.asOID();
            if (ppBasis.equals(basis)) {
                Asn1Object d4o3 = d4.readObject().assertType(Asn1Type.SEQUENCE);
                DerParser d5 = new DerParser(d4o3.getValue());
                Asn1Object d5o1 = d5.readObject().assertType(Asn1Type.INTEGER);
                Asn1Object d5o2 = d5.readObject().assertType(Asn1Type.INTEGER);
                Asn1Object d5o3 = d5.readObject().assertType(Asn1Type.INTEGER);
                ECFieldF2m eCFieldF2m = new ECFieldF2m(d4o1.asInteger().intValue(), new int[]{d5o3.asInteger().intValue(), d5o2.asInteger().intValue(), d5o1.asInteger().intValue()});
            } else {
                if (!tpBasis.equals(basis)) throw new UnsupportedOperationException("Unsupported characteristic-two-basis " + basis);
                Asn1Object d5o1 = d4.readObject().assertType(Asn1Type.INTEGER);
                ECFieldF2m eCFieldF2m = new ECFieldF2m(d4o1.asInteger().intValue(), new int[]{d5o1.asInteger().intValue()});
            }
        }
        Asn1Object d2o3 = d2.readObject().assertType(Asn1Type.SEQUENCE);
        DerParser d32 = new DerParser(d2o3.getValue());
        Asn1Object d3o12 = d32.readObject().assertType(Asn1Type.OCTET_STRING);
        d3o2 = d32.readObject().assertType(Asn1Type.OCTET_STRING);
        Asn1Object d3o3 = d32.readObject();
        BigInteger a = d3o12.toInteger();
        BigInteger b = d3o2.toInteger();
        EllipticCurve ellipticCurve = d3o3 == null ? new EllipticCurve((ECField)var3_15, a, b) : new EllipticCurve((ECField)var3_15, a, b, d3o3.getPureValueBytes());
        Asn1Object d2o4 = d2.readObject().assertType(Asn1Type.OCTET_STRING);
        Asn1Object d2o5 = d2.readObject().assertType(Asn1Type.INTEGER);
        Asn1Object d2o6 = d2.readObject().assertType(Asn1Type.INTEGER);
        ECPoint point = OpenSSHPrivateKey.getEcPoint(d2o4.getPureValueBytes());
        return new ECParameterSpec(ellipticCurve, point, d2o5.toInteger(), d2o6.toInteger().intValue());
    }
}

